#include "bob.h"

double sphere_wall_potential_bd(system_parameters *parameters, system_properties *properties,
                                double **f, double **virial, double **t_bond, int *calc_matrix)
{
    int i, j, i_bond, n_dim, n_bonds, i_site, n_sites;
    double factor, u, sigma, r_cutoff, conf_rad, conf_rad_2,
        rho2, rho6, rho12, delta_r;
    double r_mag, r_mag_2, **r;

    n_dim = parameters->n_dim;
    n_bonds = properties->bonds.n_bonds;
    n_sites = properties->sites.n_sites;
    r = properties->sites.r;

    /* Zero vdw forces, potential energy and virial. */
    u = 0.0;
    for (i = 0; i < n_dim; ++i)
        for (j = 0; j < n_dim; ++j)
            virial[i][j] = 0.0;
    for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
        for (i = 0; i < n_dim; ++i)
            f[i_bond][i] = 0.0;
    }
    for (i_site = n_bonds; i_site < n_sites; ++i_site)
        for (i = 0; i < n_dim; ++i)
            f[i_site][i] = 0.0;

    sigma = 0.5 * (1.0 + parameters->sphere_diameter);
    r_cutoff = pow(2, 1.0/6.0) * sigma;
    conf_rad = 0.5 * properties->unit_cell.h[0][0] - r_cutoff + 1.0;
    conf_rad_2 = SQR(conf_rad);
    for (i_site = n_bonds * 2; i_site < n_sites; ++i_site) {
        r_mag_2 = 0.0;
        for (i = 0; i < n_dim; ++i)
            r_mag_2 += SQR(r[i_site][i]);
        
        if (r_mag_2 > conf_rad_2) {
            r_mag = sqrt(r_mag_2);
            delta_r = -r_mag + conf_rad + r_cutoff;

            rho2 = SQR(sigma/delta_r);
            rho6 = CUBE(rho2);
            rho12 = SQR(rho6);
            factor = 24.0 * (2.0 * rho12 - rho6) * rho2;
            
            for (i = 0; i < n_dim; ++i) {
                f[i_site - n_bonds][i] = -factor * delta_r * r[i_site][i] / r_mag;
            }
            
            u += 4.0 * (rho12 - rho6) + 1.0;
        }
    }
    
    return u;
}
