// Spherocylinder movie making ability after the fact, with crosslinks

#include "bob.h"
#include "graphics.h"
#include "parse_flags.h"

#include <iostream>

int main(int argc, char *argv[]) {
    system_parameters parameters;
    system_properties properties;
    system_potential potential;
    FILE *f_posit;
    FILE **f_crosslink;
    char default_file[F_MAX], equil_file[F_MAX], opt_file[F_MAX], *grab_file;
    char posit_file[F_MAX], xlink_file[F_MAX];
    int n_dim, n_periodic, n_sites, n_posit, n_bonds, n_graph, n_types;
    int *site_1, *site_2;
    double **h, **h_inv, **a, **b, **a_perp, **r, **s, **v_bond, **u_bond, *length, *length2,
           **r_bond, **s_bond;

    // Use the new way of doing things! Almost looks exactly like a restart
    run_options run_opts = parse_opts(argc, argv, 5);

    strcpy(default_file, run_opts.default_file.c_str());
    strcpy(equil_file, run_opts.equil_file.c_str());
    strcpy(opt_file, run_opts.opt_file.c_str());

    // The posit file must be the first p file
    std::string pfile = run_opts.posit_file_names[0];
    strcpy(posit_file, pfile.c_str());

    //// Get parameters of interest
    //if (argc < 5) {
    //    std::cerr << "Usage: " << argv[0] << " default_file equil_file opt_file posit_file crosslink_file(s)(opt)\n";
    //    exit(1);
    //}

    //strcpy(default_file, argv[1]);
    //strcpy(equil_file, argv[2]);
    //strcpy(opt_file, argv[3]);
    //strcpy(posit_file, argv[4]);

    // Read in all 3 sets of parameters
    parse_parameters(default_file, &parameters);
    parse_parameters(equil_file, &parameters);
    parse_parameters(opt_file, &parameters);

    // Initialize like normal....
    init_crosslink_sphero_bd_mp(&parameters, &properties, &potential);

    // Set up some shortcuts
    n_dim = parameters.n_dim;
    n_periodic = parameters.n_periodic;
    n_sites = properties.sites.n_sites;
    n_posit = parameters.n_posit;
    n_bonds = properties.bonds.n_bonds;
    n_graph = parameters.n_graph;
    r = properties.sites.r;
    s = properties.sites.s;
    h = properties.unit_cell.h;
    h_inv = properties.unit_cell.h_inv;
    a = properties.unit_cell.a;
    b = properties.unit_cell.b;
    site_1 = properties.bonds.bond_site_1;
    site_2 = properties.bonds.bond_site_2;
    n_types = properties.crosslinks.n_types_;

    // Draw first version
    #ifndef NOGRAPH
    Graphics graphics;
    if (parameters.graph_flag == 1) {
        graphics.Init(&parameters, parameters.n_dim,
                      properties.unit_cell.h, 0);
        graphics.ResizeWindow(800,800);
        graphics.SetBoundaryType("cube");
        graphics.DrawLoop(properties.bonds.n_bonds,
                          properties.unit_cell.h,
                          properties.bonds.r_bond,
                          properties.bonds.u_bond,
                          properties.bonds.length,
                          properties.crosslinks.n_types_,
                          properties.crosslinks.stage_2_xlinks_);
    }
    #endif

    f_posit = gfopen(posit_file, "rb");
    properties.read_header_func(&parameters, &properties, f_posit);

    long int i_config = 0;
    long int n_configs = 0;

    long int start = ftell(f_posit);
    read_positions(n_dim, n_sites, h, r, f_posit);
    long int frame_size = ftell(f_posit) - start;
    fseek(f_posit, 0, SEEK_END);
    n_configs = (ftell(f_posit) - start) / frame_size;
    fseek(f_posit, start, SEEK_SET);

    // Load Xlinks
    f_crosslink = (FILE**) allocate_1d_array(n_types, sizeof(FILE*));
    if (run_opts.posit_file_names.size() > 1) {
        for (int itype = 0; itype < n_types; ++itype) {
            char crosslink_name[256];
            strcpy(crosslink_name, run_opts.posit_file_names[1+itype].c_str());
            std::cout << "loading xlinks " << crosslink_name << std::endl;
            f_crosslink[itype] = gfopen(crosslink_name, "rb");
        }
    }

    // Reset to start of file
    bool last_config;
    fseek(f_posit, start, SEEK_SET);
    i_config = 0;

    // Loop over configurations
    do {
        i_config++;
        // Read the configuration
        last_config = read_positions(n_dim, n_sites, h, r, f_posit);

        if (last_config)
            break;

        properties.time = n_posit * parameters.delta * i_config;
        properties.i_current_step = n_posit * i_config;

        n_sites = properties.sites.n_sites;
        r = properties.sites.r;
        s = properties.sites.s;
        site_1 = properties.bonds.bond_site_1;
        site_2 = properties.bonds.bond_site_2;
        n_bonds = properties.bonds.n_bonds;
        v_bond = properties.bonds.v_bond;
        u_bond = properties.bonds.u_bond;
        length = properties.bonds.length;
        length2 = properties.bonds.length2;
        s_bond = properties.bonds.s_bond;
        r_bond = properties.bonds.r_bond;

        /* Compute unit cell vectors, unit cell volume, and related quantities. */
        unit_cell_dimensions(parameters.n_dim,
                             properties.unit_cell.h,
                             properties.unit_cell.h_inv,
                             properties.unit_cell.a,
                             properties.unit_cell.b,
                             properties.unit_cell.a_perp,
                             &(properties.unit_cell.volume));

        // Compute the periodic stuff
        if (n_periodic > 0)
            periodic_boundary_conditions(n_periodic, n_sites, h, h_inv, r, s);

        // Update the bond vectors
        update_bond_vectors(n_dim, n_periodic, n_bonds, h, s, r, site_1, site_2, v_bond,
                            u_bond, length, length2);
        update_bond_positions(n_dim, n_periodic, n_bonds, h, h_inv, r, site_1, v_bond,
                              r_bond, s_bond);
        update_bond_site_positions_mp(n_dim, parameters.n_periodic, properties.bonds.n_bonds,
                                      properties.sites.n_sites, h, properties.unit_cell.h_inv,
                                      properties.bonds.bond_site_1, properties.bonds.bond_site_2,
                                      properties.bonds.r_bond, properties.bonds.u_bond, properties.bonds.
                                      length, r, properties.sites.s);
        if (run_opts.posit_file_names.size() > 1) 
            properties.crosslinks.ReadState(&parameters, &properties, f_crosslink);

        //print_simulation_step(&parameters, &properties);

        // FIXME Crosslink stuff here
        if (parameters.graph_flag && i_config % parameters.n_graph == 0) {
            graphics.Draw(properties.bonds.n_bonds,
                          properties.unit_cell.h,
                          properties.bonds.r_bond,
                          properties.bonds.u_bond,
                          properties.bonds.length,
                          properties.crosslinks.n_types_,
                          properties.crosslinks.stage_2_xlinks_);

            if (parameters.grab_flag == 1) {
                grabber(graphics.width_fb_, graphics.height_fb_, parameters.grab_file, (i_config/n_graph));
            }
        }

    } while(!last_config);

    // Normal termination
    return 0;
}
