#ifndef _TEST_CHROMATIN_MT_POTENTIAL_H_
#define _TEST_CHROMATIN_MT_POTENTIAL_H_

#include "bob.h"
#include "test_module_base.h"

class TestChromatinMTPotential : public TestModuleBase {
  public:
    TestChromatinMTPotential() : TestModuleBase() {}
    virtual ~TestChromatinMTPotential() {}

    virtual void RunTests();
    virtual void SetTests();

    bool TestChromosomesMTRecoil();
    bool TestChromosomesMTRecoilAngle();
    bool TestKinetochoreMTRecoil();
    bool TestKinetochoreTriangulation();
    bool TestKinetochoremeshMTRecoil();
    bool TestForceTorqueBalance();
    bool TestDeltas();

    void InitSystem(); // INitialize what we need for the system

    std::string testfile_;
    long seed_ = 0;
    int nmts_ = 0;
    int ndim_ = 3;

    // The potentials need some information if we have bonds
    double **f_comp_;
    double **t_comp_;
    int *calc_matrix_;

    // Deltas needed for later
    double rA[3] = {0.0};
    double uA[3] = {0.0};
    double vA[3] = {0.0};
    double wA[3] = {0.0};
    double rB[3] = {0.0};
    double uB[3] = {0.0};
    double vB[3] = {0.0};
    double wB[3] = {0.0};

    system_parameters parameters_;
    system_properties properties_;
};

#endif
