#ifndef _TEST_CHROMATIN_POTENTIAL_H_
#define _TEST_CHROMATIN_POTENTIAL_H_

#include "bob.h"
#include "test_module_base.h"

class TestChromatinPotential : public TestModuleBase {
  public:
    TestChromatinPotential() : TestModuleBase() {}
    virtual ~TestChromatinPotential() {}

    virtual void RunTests();
    virtual void SetTests();

    bool BasicLinearTest();
    bool BasicAngularTest();
    bool BasicAngularTestV();
    bool TestRandomSetup();
    bool TestForceTorqueBalance(double uret, bool print_info = true);
    bool TestDeltas();

    void InitSystem(); // INitialize what we need for the system
    void PrintUpdateData(); // Print and update the positions

    std::string testfile_;
    double ***fake_array_;
    long seed_ = 0;

    // Deltas needed for later
    double rA[3] = {0.0};
    double uA[3] = {0.0};
    double vA[3] = {0.0};
    double wA[3] = {0.0};
    double rB[3] = {0.0};
    double uB[3] = {0.0};
    double vB[3] = {0.0};
    double wB[3] = {0.0};

    system_parameters parameters_;
    system_properties properties_;
};

#endif
