// Implementation of the test manager class
#include <iostream>

#include "test_manager.h"

// New Hotness for unit tests
#include "unit_test_af_mt_harmonic_potential.h"
#include "unit_test_antiparallel_overlap.h"
#include "unit_test_kinetochoremesh_potential.h"
#include "unit_test_lookup_table.h"
#include "unit_test_min_distance.h"
#include "unit_test_probabilities.h"
#include "unit_test_vesicle_management.h"
#include "unit_test_xlink_management.h"
#include "unit_test_wall_forces.h"
#include "unit_test_force_dependent_polymerization.h"

// New hotness for integration tests
#include "integration_test_chromosomes.h"
#include "integration_test_fokkerplanck.h"
#include "integration_test_xlinks.h"

#define REGISTER_TEST_MODULE(n) test_module_factory_.register_class<n>(#n);

// For right now, this is goddamn magic
// email: christopher.edelmaier@colorado.edu
void TestManager::RegisterTests() {
    REGISTER_TEST_MODULE(UnitTestForceDependentPolymerization);
    REGISTER_TEST_MODULE(UnitTestWallForces);
    REGISTER_TEST_MODULE(UnitTestXlinkManagement);
    REGISTER_TEST_MODULE(UnitTestAntiparallelOverlap);
    REGISTER_TEST_MODULE(UnitTestVesicleManagement);
    REGISTER_TEST_MODULE(UnitTestProbabilities);
    REGISTER_TEST_MODULE(UnitTestLookupTable);
    REGISTER_TEST_MODULE(UnitTestAFMTHarmonicPotential);
    REGISTER_TEST_MODULE(UnitTestMinDistance);
    REGISTER_TEST_MODULE(UnitTestKinetochoremeshPotential);

    // Integration tests
    REGISTER_TEST_MODULE(IntegrationTestChromosomes);
    REGISTER_TEST_MODULE(IntegrationTestFokkerPlanck);
    REGISTER_TEST_MODULE(IntegrationTestXlinks);
}

void TestManager::SetTests() {
    YAML::Node node = YAML::LoadFile(filename_);
    std::cout << "Welcome to NAB Test Manager\n";
    std::cout << "Loading Tests From ->\n";
    std::cout << "   " << filename_ << std::endl;

    for (auto alltests = test_module_factory_.m_classes.begin(); alltests != test_module_factory_.m_classes.end(); ++alltests) {
        if (node[alltests->first]) {
            TestModuleBase *t = (TestModuleBase*)test_module_factory_.construct(alltests->first);
            t->SetFilename(node[alltests->first].as<std::string>());
            tests_.push_back(t);
        }
    }
}

void TestManager::RunTests() {
    std::cout << "TestManager -- Running " << tests_.size() << " tests\n";

    for (auto &kv : tests_) {
        kv->SetTests();
        kv->RunTests();
    }

    std::cout << "TestManager -- Tests Completed!\n";
}
