#ifndef _TEST_MODULE_BASE_H_
#define _TEST_MODULE_BASE_H_

#include <functional>
#include <map>

#include <yaml-cpp/yaml.h>

#ifndef _PARAMETERS_H
typedef struct system_parameters system_parameters;
#endif
#ifndef _SYSTEM_PROPERTIES_H
typedef struct system_properties system_properties;
#endif

class TestModuleBase {

  public:
    TestModuleBase() {}
    virtual ~TestModuleBase() {}

    virtual void RunTests() = 0;
    virtual void SetTests() = 0;

    void SetFilename(const std::string& filename) {filename_ = filename;}

    std::string filename_;
    std::map<std::string, std::function<bool(void)>> tests_;
    YAML::Node node_;
    YAML::Node var_subnode_; // current variant parameters of interest
    int iv_; // current variant number

};

#endif
