#ifndef _TEST_TRIANGLES_H_
#define _TEST_TRIANGLES_H_

#include "bob.h"
#include "test_module_base.h"

class TestTriangles : public TestModuleBase {
  public:
    std::string testfile_;

    TestTriangles() : TestModuleBase() {}
    virtual ~TestTriangles() {}

    virtual void RunTests();
    virtual void SetTests();

    bool TestMinimumDistance();
    bool TestMinimumDistancePoly();
    bool TestMinimumDistanceKCMT();

    void RunMinimumDistance(double **verts, double *r1, double *r2);
    void UnitTriangle(double **verts);
    void UnitTriangle(std::vector<std::array<double, 3>> &verts,
                      std::vector<int> &indicies);
    void UnitHexagon(std::vector<std::array<double, 3>> &verts,
                     std::vector<int> &indicies);
    void UnitSquare(std::vector<std::array<double, 3>> &verts,
                    std::vector<int> &indicies);
};

#endif
