#include "bob.h"
#include "unit_test_antiparallel_overlap.h"

#include <iostream>

//TODO Define small
#define SMALL 1.0e-9

// Run the tests and all their variants
void UnitTestAntiparallelOverlap::RunTests() {
    std::cout << "****************\n";
    std::cout << "Unit Test Antiparallel Overlap run tests\n";
    std::cout << "****************\n";

    for (auto &kv : tests_) {
        std::cout << "----------------\n";
        std::cout << "Test : " << kv.first << std::endl;
        std::cout << "----------------\n";

        for (int iv = 0; iv < node_["Tests"][kv.first].size(); ++iv) {
            std::cout << "  Variant : " << iv << std::endl;
            var_subnode_ = node_["Tests"][kv.first][iv];
            iv_ = iv;
            auto result = kv.second();

            if (!result) {
                std::cout << "Test : " << kv.first << " failed, check output!\n";
                exit(1);
            }
        }
    }
}

// Set up the possible tests to run
void UnitTestAntiparallelOverlap::SetTests() {
    node_ = YAML::LoadFile(filename_);

    // Check against names to bind method calls
    if (node_["Tests"]["DefinedConfig"]) {
        tests_["DefinedConfig"] = std::bind(&UnitTestAntiparallelOverlap::DefinedConfig, this);
    }
}

//Tests the overlap value of two rods, with a known result
bool UnitTestAntiparallelOverlap::DefinedConfig(){

    double r1[3], r2[3], u1[3], u2[3], l1, l2;
    double s1[3]={0};
    double s2[3]={0};
    double **h;
    int ndim= var_subnode_["params"]["r1"].size();
    int nperiodic=0;
    double result = var_subnode_["result"].as<double>();

    //std::cout<<"  node["<<iv<<"]: "<<node<<std::endl;
    l1 = var_subnode_["params"]["len1"].as<double>();
    l2 = var_subnode_["params"]["len2"].as<double>();
    for (int i=0; i<ndim; ++i){
        r1[i] = var_subnode_["params"]["r1"][i].as<double>();
        r2[i] = var_subnode_["params"]["r2"][i].as<double>();
        u1[i] = var_subnode_["params"]["u1"][i].as<double>();
        u2[i] = var_subnode_["params"]["u2"][i].as<double>();
    }

    normalize_array(ndim, u1);
    normalize_array(ndim, u2);

    double u = antiparallel_overlap(ndim, nperiodic, h, 1.6,
                                r1, s1, u1, l1,
                                r2, s2, u2, l2);

    std::cout<< "    u = "<< u<< std::endl;
    std::cout<< "    result = "<< result << std::endl;
    

    if ( ABS((u - result)) >= SMALL) return false;
    else return true;

}

bool UnitTestAntiparallelOverlap::StandardConfigSweep(){
    std::cout<<"StandardConfigSweep not implemented"<<std::endl;
    exit(1);
    return false;

}

#undef SMALL
