
#include "unit_test_force_dependent_polymerization.h"
#include "macros.h"

#include <iostream>
#include <map>

double calc_polymerization_speed(double v_poly, double f_s, double f_par);

void UnitTestForceDependentPolymerization::RunTests(){

    std::cout << "**********************************************\n";
    std::cout << "Test Force Dependent Polymerization run tests\n";
    std::cout << "**********************************************\n";

    for (auto &kv : tests_) {
        std::cout << "----------------\n";
        std::cout << "Test : " << kv.first << std::endl;
        std::cout << "----------------\n";
        // Loop over a single tests variations 
        for (int iv = 0; iv < node_[kv.first].size(); ++iv) {
            std::cout << "  Variant : " << iv << std::endl;
            var_subnode_ = node_[kv.first][iv];
            iv_ = iv;
            auto result = kv.second();
        }
    }
}

void UnitTestForceDependentPolymerization::SetTests(){
    node_ = YAML::LoadFile(filename_);
    tests_["SimpleCheck"] = std::bind(&UnitTestForceDependentPolymerization::SimpleCheck, this);
    tests_["MatchCurve"] = std::bind(&UnitTestForceDependentPolymerization::MatchCurve, this);
}

bool UnitTestForceDependentPolymerization::SimpleCheck() {
    std::cout<<"     * SimpleCheck * \n";
    return true;
}

bool UnitTestForceDependentPolymerization::MatchCurve() {
    double mt_stall_force = var_subnode_["params"]["mt_stall_force"].as<double>();
    double v_poly = var_subnode_["params"]["v_poly"].as<double>();
    double max_error = var_subnode_["results"]["max_error"].as<double>();

    fprintf(stdout, "    mt stall force = %f, v_poly = %f\n", mt_stall_force, v_poly);
    fflush(stdout);

    // TODO Make sure inputs and outputs are the same length
    for (int i=0; i < var_subnode_["params"]["inputs"].size(); i++){
        double f = var_subnode_["params"]["inputs"][i].as<double>();
        double sim_vel = calc_polymerization_speed(v_poly, mt_stall_force, f); 
        double calc_vel = var_subnode_["results"]["outputs"][i].as<double>(); ;
        double error = ABS(sim_vel-calc_vel);

        fprintf(stdout, "   input force: %f --> sim velocity = %f, calc velocity = %f\n    error = %f, max error = %f\n", f, sim_vel, calc_vel, error, max_error);
        fflush(stdout);
    }


    return true;
}
