#ifndef _UNIT_TEST_KINETOCHOREMESH_POTENTIAL_H_
#define _UNIT_TEST_KINETOCHOREMESH_POTENTIAL_H_

#include "test_module_base.h"

class UnitTestKinetochoremeshPotential: public TestModuleBase {
  public:
    UnitTestKinetochoremeshPotential() {}
    virtual ~UnitTestKinetochoremeshPotential() {}

    virtual void RunTests();
    virtual void SetTests();

    // Specialized init functionality
    void InitSystem(system_parameters *parameters,
                    system_properties *properties);
    void InitXsomeParams(system_parameters *parameters, 
                         system_properties *properties);
    void InitXsomeParams(system_parameters *parameters, 
                         system_properties *properties,
                         YAML::Node param_node);
    YAML::Node GetXsomeParamNode(std::string x_file, YAML::Node mod_node);
    void FinishInitSystem(system_parameters *parameters,
                          system_properties *properties);

    // Tests
    bool TestPotentialUpdate();

    // Helper functions
    bool TestForceTorqueBalance(system_parameters *parameters,
                                system_properties *properties,
                                bool print_info);

    // bookeeping and stuffs
    double **f_comp_;
    double **t_comp_;
    double **virial_comp_;
    int *calc_matrix_;

    // Printing functions
    void PrintMTs(system_parameters *parameters,
                  system_properties *properties);
};
#endif
