#ifndef _UNIT_TEST_LOOKUP_TABLE_H_
#define _UNIT_TEST_LOOKUP_TABLE_H_

#include "test_module_base.h"

class LookupTable;
class LookupTableAdvanced;

class UnitTestLookupTable : public TestModuleBase {
  public:
    UnitTestLookupTable() {}
    virtual ~UnitTestLookupTable() {}

    virtual void RunTests();
    virtual void SetTests();

    bool CheckSelectedAnswers(LookupTable *lut,
                              std::map<int, std::map<int, double>> *sa);
    bool CheckSelectedAnswersLookup(LookupTable *lut,
                                    std::map<int, std::map<int, double>> *sa);
    bool CheckSelectedAnswersLookup(LookupTable *lut,
                                    std::map<double, std::map<double, double>> *sa);
    bool CheckSelectedAnswersAdvanced(LookupTableAdvanced *lut,
                                      std::vector<std::tuple<double, double, double, double, double>> *sa,
                                      double tolerance = 0.000001);
    bool CheckInvert(LookupTableAdvanced *lut,
                     std::vector<std::tuple<double, double, double, double, double>> *sa,
                     double tolerance = 0.000001);
    bool CheckInvertOriginal(LookupTable *lut,
                             std::vector<std::tuple<double, double, double, double, double>> *sa,
                             double tolerance = 0.000001);

    // Different tests
    bool BasicTest12();
    bool BasicTestFdep();
    bool LookupTest12();
    bool LookupTest12Values();
    bool AdvancedTest();
    bool Invert();
};

#endif
