// Unit test for minimum distance calculations, along with hopeful timing information

#ifndef _UNIT_TEST_MIN_DISTANCE_H_
#define _UNIT_TEST_MIN_DISTANCE_H_

#include "test_module_base.h"

/// @brief UnitTestMinDistance
class UnitTestMinDistance : public TestModuleBase {
  public:
    UnitTestMinDistance() {}
    virtual ~UnitTestMinDistance() {}

    virtual void RunTests();
    virtual void SetTests();

    bool TestRandomSetup();

    bool TestMinDistanceSpheroDr(system_parameters *parameters,
                                 system_properties *properties,
                                 double *prminmag2,
                                 double *plambda,
                                 double *pmu,
                                 double *prmin);
    bool TestMinDistanceSegments(system_parameters *parameters,
                                 system_properties *properties,
                                 double *prminmag2,
                                 double *plambda,
                                 double *pmu,
                                 double *prmin);

    // Specialized init functionality
    void InitSystem(system_parameters *parameters,
                    system_properties *properties);
    void FinishInitSystem(system_parameters *parameters,
                          system_properties *properties);

    // bookeeping and stuffs
    double **f_comp_;
    double **t_comp_;
    double **virial_comp_;
    int *calc_matrix_;

    // Printing functions
    void PrintMTs(system_parameters *parameters,
                  system_properties *properties);
};

#endif
