// Implementation of unit tests for vesicles

#include "bob.h"
#include "unit_test_vesicle_management.h"
#include "vesicle.h"

//typedef std::vector<XlinkEntry> xlink_list;
#include <iostream>

// Run the tests and all their variants
void UnitTestVesicleManagement::RunTests() {
    std::cout << "****************\n";
    std::cout << "Unit Test Vesicle Management run tests\n";
    std::cout << "****************\n";

    for (auto &kv : tests_) {
        std::cout << "----------------\n";
        std::cout << "Test : " << kv.first << std::endl;
        std::cout << "----------------\n";

        for (int iv = 0; iv < node_["Tests"][kv.first].size(); ++iv) {
            std::cout << "  Variant : " << iv << std::endl;
            var_subnode_ = node_["Tests"][kv.first][iv];
            iv_ = iv;
            auto result = kv.second();

            if (!result) {
                std::cout << "Test : " << kv.first << " failed, check output!\n";
                exit(1);
            }
        }
    }
}

void UnitTestVesicleManagement::BasicInit(system_parameters * parameters,
                                          system_properties * properties){

    // Set up random number generators
    gsl_rng_env_setup();
    properties->rng.T = gsl_rng_default;
    properties->rng.r = gsl_rng_alloc(properties->rng.T);
    gsl_rng_set(properties->rng.r, parameters->seed);

    // Generic parameter initialization
    parse_parameters_node(var_subnode_["params"], parameters);
    //init_default_params(parameters);

    // Costum parameter initialization
    parameters->n_periodic = 0;
    int n_dim = parameters->n_dim = 3;
    parameters->n_steps = 1000000;
    parameters->delta = .00025;
    properties->unit_cell.h = (double **) allocate_2d_array(n_dim, n_dim, sizeof(double));
    for (int i = 0; i < parameters->n_dim; ++i) {
        properties->unit_cell.h[i][i] = 100;
    }

    // If there are bonds, intialize them
    if (var_subnode_["params"]["mt_file"]) {
        std::string mt_file = var_subnode_["params"]["mt_file"].as<std::string>();
        YAML::Node mtnode = YAML::LoadFile(mt_file.c_str());
        int nmts = mtnode["mts"]["mt"].size();
        parameters->n_spheros = properties->bonds.n_bonds = nmts;
        init_unit_cell_structure(parameters, properties);
        int nsites = 2*nmts;
        std::cout << "Nmts: " << nmts << std::endl;
        std::cout << "Nsites: " << nsites << std::endl;
        properties->sites.n_sites = nsites;
        properties->sites.v = (double**) allocate_2d_array(nsites, n_dim, sizeof(double));
        properties->sites.r = (double**) allocate_2d_array(nsites, n_dim, sizeof(double));
        init_site_structure_sphero(parameters, properties);
        init_bond_structure_sphero(parameters, properties);
        for (int imt = 0; imt < nmts; ++imt) {
            for (int i = 0; i < n_dim; ++i) {
                properties->bonds.r_bond[imt][i] = mtnode["mts"]["mt"][imt]["r"][i].as<double>();
                properties->bonds.u_bond[imt][i] = mtnode["mts"]["mt"][imt]["u"][i].as<double>();
            }
            properties->bonds.length[imt] = mtnode["mts"]["mt"][imt]["length"].as<double>();
        }

        // Also initialize the force computation networks?
    } else {
        properties->bonds.n_bonds = 0;
    }

    return;
}

// Set up the possible tests to run
void UnitTestVesicleManagement::SetTests() {
    node_ = YAML::LoadFile(filename_);

    // Check against names to bind method calls
    if (node_["Tests"]["Init"]) {
        tests_["Init"] = std::bind(&UnitTestVesicleManagement::Init, this);
    }
    if (node_["Tests"]["StepKMC"]) {
        tests_["StepKMC"] = std::bind(&UnitTestVesicleManagement::StepKMC, this);
    }
}

bool UnitTestVesicleManagement::Init() {
    // Test the diffusion of stage0 xlinks
    bool success = true;

    system_parameters parameters;
    system_properties properties;

    // Parameters specific to stage0diffusion test, can be changed in param subnode
    std::string v_file = var_subnode_["params"]["v_file"].as<std::string>();
    YAML::Node vnode = YAML::LoadFile(v_file.c_str());

    BasicInit(&parameters, &properties);

    VesicleManagement v_mgt;
    v_mgt.Init(&parameters, &properties, v_file.c_str());

    return success;
}

bool UnitTestVesicleManagement::StepKMC() {
    bool success = true;

    system_parameters parameters;
    system_properties properties;

    // Parameters specific to stage0diffusion test, can be changed in param subnode
    std::string v_file = var_subnode_["params"]["v_file"].as<std::string>();
    YAML::Node vnode = YAML::LoadFile(v_file.c_str());

    BasicInit(&parameters, &properties);
    VesicleManagement v_mgt;
    v_mgt.Init(&parameters, &properties, v_file.c_str());
    v_mgt.StepKMC(&parameters, &properties);

    v_mgt.PrintFrame();

    return success;
}
