#include "unit_test_wall_forces.h"
#include "macros.h"
#include <iostream>
#include <map>

double calc_non_monotonic_wall_force(double ne_ratio, double f0, double delta_r);

void UnitTestWallForces::RunTests(){

    std::cout << "**********************************************\n";
    std::cout << "Test Wall Forces run tests\n";
    std::cout << "**********************************************\n";

    for (auto &kv : tests_) {
        std::cout << "----------------\n";
        std::cout << "Test : " << kv.first << std::endl;
        std::cout << "----------------\n";
        // Loop over a single tests variations 
        for (int iv = 0; iv < node_[kv.first].size(); ++iv) {
            std::cout << "  Variant : " << iv << std::endl;
            var_subnode_ = node_[kv.first][iv];
            iv_ = iv;
            auto result = kv.second();
        }
    }
}

void UnitTestWallForces::SetTests(){
    node_ = YAML::LoadFile(filename_);
    tests_["NonMonotonicDistance"] = std::bind(&UnitTestWallForces::NonMonotonicDistance, this);
}

bool UnitTestWallForces::NonMonotonicDistance(){
    double ne_ratio = var_subnode_["params"]["ne_ratio"].as<double>();
    double wf_factor = var_subnode_["params"]["wall_force_factor"].as<double>();
    double max_error = var_subnode_["results"]["max_error"].as<double>();
    //std::cout<<"     * in NonMonotonicDistance * \n";
    for (int i=0; i < var_subnode_["params"]["delta_r"].size(); i++){
        double dr = var_subnode_["params"]["delta_r"][i].as<double>();
        double f = calc_non_monotonic_wall_force(ne_ratio, wf_factor, dr);
        double f_calc = var_subnode_["results"]["wall_forces"][i].as<double>();
        double error = ABS(f-f_calc);
        fprintf(stdout, "   input distance: %f --> sim force = %f, calc force = %f\n    error = %f, max error = %f\n", dr, f, f_calc, error, max_error);
        fflush(stdout);
    }
    return true;
}

