/* This routine calculates scaled and real positions of bonds.
 
 Input: number of spatial dimensions (n_dim)
 number of periodic dimensions (n_periodic)
 number of bonds (n_bonds)
 unit cell matrix (h)
 inverse unit cell matrix (h_inv)
 array of real site positions (r)
 array of labels of first bond endpoint (site_1)
 array of bond_vectors (v_bond)
 
 Output: array of real bond positions (r_bond)
 array of scaled bond positions (s_bond) */

#include "bob.h"

void update_bond_positions(int n_dim, int n_periodic, int n_bonds, double **h, double **h_inv,
                           double **r, int *site_1, double **v_bond,
                           double **r_bond, double **s_bond)
{
    int i_bond;

    /* Loop over bonds and compute bond positions. */
    for (i_bond = 0; i_bond < n_bonds; ++i_bond)
        bond_position(n_dim, n_periodic, h, h_inv, r, site_1[i_bond], v_bond[i_bond],
                      r_bond[i_bond], s_bond[i_bond]);

    return;
}
