/* This routine calculates bond vectors and related quantities.
 
 Input: number of spatial dimensions (n_dim)
 number of periodic dimensions (n_periodic)
 number of bonds (n_bonds)
 unit cell matrix (h)
 array of scaled site positions (s)
 array of real site positions (r)
 arrays of bond endpoint site labels (site_1, site_2)
 
 Output: array of bond vectors (v_bond)
 array of unit bond vectors (u_bond)
 array of bond lengths (length)
 array of squared bond lengths (length2) */

#include "bob.h"

void update_bond_vectors(int n_dim, int n_periodic, int n_bonds, double **h,
                         double **s, double **r, int *site_1, int *site_2,
                         double **v_bond, double **u_bond, double *length, double *length2)
{
    int i_bond;

    /* Loop over bonds and compute bond vectors. */
    for (i_bond = 0; i_bond < n_bonds; ++i_bond)
        bond_vector(n_dim, n_periodic, h, s, r, site_1[i_bond], site_2[i_bond],
                    v_bond[i_bond], u_bond[i_bond], &length[i_bond], &length2[i_bond]);

    return;
}
