/* Update neighbor lists.

   Input: pointer to parameters structure (parameters)
   pointer to properties structure (properties)

   Output: updated neighbor lists are returned. */

#include "bob.h"

void update_neighbor_lists_sphero(system_parameters *parameters, system_properties *properties) {
    int n_dim, n_periodic, i_bond, nl_update_flag, n_sites, n_bonds, nl_cell_list, 
        nl_twoway_flag, update,  i, i_site;
    double r_cutoff_max, skin, **h, *a_perp, **dr_tot, **r_bond, **s_bond, **u_bond,
        *length, *length_max;
    nl_list *neighbs;

    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    n_periodic = parameters->n_periodic;
    nl_update_flag = parameters->nl_update_flag;
    skin = parameters->skin;
    h = properties->unit_cell.h;
    a_perp = properties->unit_cell.a_perp;
    n_sites = properties->sites.n_sites;
    dr_tot = properties->sites.dr_tot;
    n_bonds = properties->bonds.n_bonds;
    r_bond = properties->bonds.r_bond;
    s_bond = properties->bonds.s_bond;
    u_bond = properties->bonds.u_bond;
    length = properties->bonds.length;
    r_cutoff_max = parameters->r_cutoff;
    nl_twoway_flag = parameters->nl_twoway_flag;
    length_max = &(properties->bonds.length_max);
    nl_cell_list = parameters->nl_cell_list;

    neighbs = properties->neighbors.neighbs;

    /* Update neighbor lists. */
    if (nl_update_flag == 0)    /* All-pairs search. */
        update_neighbor_lists_sphero_all_pairs(n_dim, n_periodic, h, skin, r_cutoff_max,
                                               n_bonds, r_bond, s_bond, u_bond, length,
                                               neighbs, nl_twoway_flag);
    else {                      /* Cell search. */
        if (parameters->child_list_flag == 0) {
            for (i_bond = 0; i_bond < n_bonds; ++i_bond)
                *length_max = MAX(*length_max, length[i_bond]);
            update = properties->cells[nl_cell_list].check_cell_lists(n_bonds, a_perp, s_bond,
                                                             r_cutoff_max + *length_max + skin);

            if (!update)
                properties->cells[nl_cell_list].update_cell_lists(s_bond);

            update_neighbor_lists_sphero_cells(n_dim, n_periodic, h,
                                               skin, r_cutoff_max,
                                               n_bonds, r_bond,
                                               s_bond, u_bond,
                                               length, &(properties->cells[0]),
                                               neighbs,
                                               nl_twoway_flag);
        }
        else {
        //     update_child_positions(parameters, properties);

        //     update =
        //         check_cell_lists(n_dim, n_periodic, a_perp,
        //                          properties->child_bonds.n_bonds,
        //                          properties->child_bonds.s_bond, n_shell_nl,
        //                          r_cutoff_max + properties->child_bonds.length_max + skin,
        //                          &(properties->cells[nl_cell_list]));


        //     if (!update) {
        //         update_cell_lists(n_dim, properties->child_bonds.n_bonds,
        //                           properties->child_bonds.s_bond,
        //                           &(properties->cells[nl_cell_list]));
        //     }

        //     update_neighbor_lists_sphero_child_cells(n_dim, n_periodic, h, skin, n_bonds,
        //                                              properties->child_bonds.n_bonds,
        //                                              r_bond, s_bond, u_bond, length, r_cutoff_max,
        //                                              &(properties->cells[nl_cell_list]),
        //                                              neighbs, properties->child_bonds.parent_bond);
            error_exit("Child positions cell lists not currently supported for spherocylinders\n");
        }
        
    }

    /* Zero movement accumulators for all sites. */
    for (i_site = 0; i_site < n_sites; ++i_site)
        for (i = 0; i < n_dim; ++i)
            dr_tot[i_site][i] = 0.0;

    return;
}
