#include "bob.h"

#include <iostream>

// Update the spindle state, since read positions isn't going to do this
// fully and completely, and might have issues

void update_spindle_state(system_parameters *parameters,
                          system_properties *properties) {
    
    /* Update bond vectors. */
    update_bond_vectors(parameters->n_dim,
                        parameters->n_periodic,
                        properties->bonds.n_bonds,
                        properties->unit_cell.h,
                        properties->sites.s,
                        properties->sites.r,
                        properties->bonds.bond_site_1,
                        properties->bonds.bond_site_2,
                        properties->bonds.v_bond,
                        properties->bonds.u_bond,
                        properties->bonds.length,
                        properties->bonds.length2);
    update_bond_positions(parameters->n_dim,
                          parameters->n_periodic,
                          properties->bonds.n_bonds,
                          properties->unit_cell.h,
                          properties->unit_cell.h_inv,
                          properties->sites.r,
                          properties->bonds.bond_site_1,
                          properties->bonds.v_bond,
                          properties->bonds.r_bond,
                          properties->bonds.s_bond);
    update_bond_site_positions(parameters->n_dim,
                               parameters->n_periodic,
                               properties->bonds.n_bonds,
                               properties->sites.n_sites,
                               properties->unit_cell.h,
                               properties->unit_cell.h_inv,
                               properties->bonds.bond_site_1,
                               properties->bonds.bond_site_2,
                               properties->bonds.r_bond,
                               properties->bonds.u_bond,
                               properties->bonds.length,
                               properties->sites.r,
                               properties->sites.s);

    // Reset the diffusion on the bonds (they are different lengths from reload now)
    configure_diffusion_sphero(parameters, properties);
    update_neighbor_lists_sphero_all_pairs_mp(parameters->n_dim,
                                              parameters->n_periodic,
                                              properties->unit_cell.h,
                                              parameters->skin,
                                              parameters->r_cutoff,
                                              properties->bonds.n_bonds,
                                              properties->bonds.r_bond,
                                              properties->bonds.s_bond,
                                              properties->bonds.u_bond,
                                              properties->bonds.length,
                                              properties->neighbors.neighbs,
                                              parameters->nl_twoway_flag);

    // Update the positions of the spindle pole bodies, specifically, anchors
    for (int i_anchor = 0; i_anchor < properties->anchors.n_anchors; ++i_anchor) {
        double *r_anchor = properties->anchors.r_anchor[i_anchor];
        double *u_anchor = properties->anchors.u_anchor[i_anchor];
        double *v_anchor = properties->anchors.v_anchor[i_anchor];
        double *w_anchor = properties->anchors.w_anchor[i_anchor];

        for (al_list::iterator p = properties->anchors.anchor_list[i_anchor].begin();
             p < properties->anchors.anchor_list[i_anchor].end();
             p++) {
            double factor_u = dot_product(3, p->pos_rel, u_anchor);
            double factor_v = dot_product(3, p->pos_rel, v_anchor);
            double factor_w = dot_product(3, p->pos_rel, w_anchor);
            
            // Calculate new lab frame coordinate
            for (int i = 0; i < 3; ++i) {
                p->pos[i] = r_anchor[i] + factor_u * u_anchor[i] +
                    factor_v * v_anchor[i] + factor_w * w_anchor[i];
            }
            //Yank it back to the surface of sphere because numerical errors are annoying
            double conf_rad = 0.5 * properties->unit_cell.h[0][0];
            double norm_factor = conf_rad / sqrt(dot_product(3, p->pos, p->pos));
            for (int i = 0; i < 3; ++i) p->pos[i] *= norm_factor; 

            // Make sure that we properly attack the orientation of the anchor list
            // Orientations!
            double original_u[3] = {0.0};
            for (int i = 0; i < 3; ++i) {
                original_u[i] = p->u[i];
                p->u[i] = p->u_rel[0] * u_anchor[i] +
                          p->u_rel[1] * v_anchor[i] +
                          p->u_rel[2] * w_anchor[i];
            }
        }
    }
}
