#ifndef _VESICLE_H_
#define _VESICLE_H_

class VesicleManagement;

class Vesicle {

  public:

    Vesicle();
    void Init(VesicleManagement *parent,
              int idx,
              double *r,
              double *u,
              double *v,
              double *w);
    void Allocate();
    void CreateRefVectors();
    void CreateBindingSites();

    // Print functionality
    void PrintFrame();

    // Create and update the neighbor list for each motor on the vesicle
    void UpdateNeighbors(int ndim,
                         int nperiodic,
                         int nbonds,
                         double **h,
                         double **rbond,
                         double **sbond,
                         double **ubond,
                         double *lbond,
                         double rcutoff2);
    void ClearNeighbors(int isite);

    // Action functions
    void Step(int ndim,
              int nperiodic,
              int nbonds,
              double **h,
              double **rbond,
              double **sbond,
              double **ubond,
              double *lbond,
              double delta,
              gsl_rng *r);

    // kinetic Monte Carlo functions
    void Update_1_2(int ndim,
                    int nperiodic,
                    int nbonds,
                    double **h,
                    double **rbond,
                    double **sbond,
                    double **ubond,
                    double *lbond);
    double Stage_1_2_Probability(int n_dim,
                                 double *dr,
                                 double *uline,
                                 double length2);
    bool Insert_1_2(system_parameters *parameters,
                    system_properties *properties);
    bool Convert_1_2(system_parameters *parameters,
                     system_properties *properties,
                     int ibond,
                     int isite);
    double CalcForce(int ndim,
                     int nperiodic,
                     double **h,
                     int isite,
                     double *rbond,
                     double *sbond,
                     double *ubond,
                     double lbond,
                     double *f);

  private:

    double RandomPosition(int ndim,
                          int nperiodic,
                          double **h,
                          double *r1,
                          double *s1,
                          double *rline,
                          double *sline,
                          double *uline,
                          double lline,
                          double kb,
                          gsl_rng *r);

  public:

    bool trip_update_on_removal_ = false;

    int idx_ = -1; // id in the list from parent
    int nsites_ = -1; // number of motor sites
    int nbonds_ = -1; // number of bonds in the system

    double n_exp_tot_ = 0.0; // total for all motors/sites

    // Fuzzy ball stuff
    int *attach_;
    double *r_;
    double *u_;
    double *v_;
    double *w_;
    double *n_exp_; // "raw" probability density (per t) for attaching
                    // any nearby spherocylinder
    double *cross_pos_; // linear position along bond for isite
    double *upot_; // potential energy in isite
    double *feff_; // effective force on isite, which gives us force dpeendent rate kinetics
    double **dr_tot_; // total accumulator for sites
    double **r_cross_; // site cross vector (from site to bond attachment)
    double **flink_; // force vector for isite

    // My particular anchor entry, neighbors, etc
    al_list *anchors_;
    nl_list *neighbors_;

  private:

    int ndim_ = 0;

    VesicleManagement *parent_;

};

#endif
