#include "bob.h"

double wall_attach_potential_bd(system_parameters *parameters, system_properties *properties,
                                double **f_bond, double **virial, double **t_bond, int *calc_matrix)
{
    int i, j, i_site, i_bond,  n_dim, n_bonds, n_anchors;
    double u, r_mag2, k, **r, **r_bond, *length, **u_bond, dr[3], r_contact[3];
    
    static double **origin;
    static int first_call = 1;

    n_dim = parameters->n_dim;
    n_bonds = properties->bonds.n_bonds;
    n_anchors = properties->anchors.n_anchors;
    r_bond = properties->bonds.r_bond;
    r = properties->sites.r;
    length = properties->bonds.length;
    u_bond = properties->bonds.u_bond;

    /* Zero vdw forces, potential energy and virial. */
    u = 0.0;
    for (i = 0; i < n_dim; ++i)
        for (j = 0; j < n_dim; ++j)
            virial[i][j] = 0.0;
    memset(f_bond[0], 0, n_bonds * n_dim * sizeof(double));
    memset(t_bond[0], 0, n_bonds * 3 * sizeof(double));

    if (first_call) {
        origin = (double**) allocate_2d_array(n_bonds, n_dim, sizeof(double));
        for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
            i_site = properties->bonds.bond_site_1[i_bond];
            for (i = 0; i < n_dim; ++i) 
                origin[i_bond][i] = r[i_site][i];
        }
        first_call = 0;
    }
    
    /* Just grab the first SPB k value we find */
    k = 50.0;
    if(n_anchors > 0) {
        k = properties->anchors.k[0];
    }
    for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
        for (i = 0; i < n_dim; ++i)
            r_contact[i] = -0.5 * length[i_bond] * u_bond[i_bond][i];
        for (i = 0; i < n_dim; ++i)
            dr[i] = r_bond[i_bond][i] - origin[i_bond][i] + r_contact[i];

        r_mag2 = 0.0;
        for (i = 0; i < n_dim; ++i)
            r_mag2 += SQR(dr[i]);

        for (i = 0; i < n_dim; ++i)
            f_bond[i_bond][i] = -k * dr[i];
        
        cross_product(r_contact, f_bond[i_bond], t_bond[i_bond], n_dim);

        calc_matrix[i_bond] = 1;

        u += 0.5 * k * r_mag2;
    }

    return u;
}
