/* This routine writes a single configuration (unit cell matrix and site positions and velocities)
   to an output file.

   Input: pointer to parameters structure (parameters)
          pointer to properties structure (properties)
          name of configuration file (config_file)

   Output: a single configuration is written to the configuration file */

#include "bob.h"

void write_config(system_parameters *parameters, system_properties *properties, char *config_file)
{
    FILE *f_config;
    int n_dim, n_sites, i, i_site;
    double **h, **r, **v;

    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    n_sites = properties->sites.n_sites;
    h = properties->unit_cell.h;
    r = properties->sites.r;
    v = properties->sites.v;

    /* Open output file. */
    f_config = gfopen(config_file, "w");

    /* Write header to output file. */
    properties->write_header_func(parameters, properties, f_config);

    /* Write unit cell matrix to output file. */
    for (i = 0; i < n_dim; ++i)
        fwrite(h[i], sizeof(double), n_dim, f_config);

    /* Write site positions and velocities to output file. */
    for (i_site = 0; i_site < n_sites; ++i_site) {
        fwrite(r[i_site], sizeof(double), n_dim, f_config);
        fwrite(v[i_site], sizeof(double), n_dim, f_config);
    }

    /* Close output file. */
    fclose(f_config);

    return;
}
