#include "bob.h"

void write_config_spb_dynamics(system_parameters *parameters,
                               system_properties *properties,
                               char const *config_file) {
    int i, i_anchor, i_bond, n_anchors, n_dim, n_bonds, i_site, n_sites;
    double sys_diameter, sphere_diameter;
    double **r_anchor, **r, **r_bond, **u_bond, *length, *pos;
    FILE *f_config;
    
    f_config = gfopen(config_file, "w");

    n_dim = parameters->n_dim;
    sys_diameter = properties->unit_cell.h[0][0];
    sphere_diameter = parameters->sphere_diameter;
    n_anchors = properties->anchors.n_anchors;
    r_anchor = properties->anchors.r_anchor;
    n_bonds = properties->bonds.n_bonds;
    r_bond = properties->bonds.r_bond;
    u_bond = properties->bonds.u_bond;
    length = properties->bonds.length;
    n_sites = properties->sites.n_sites;
    r = properties->sites.r;
    al_list *anchor_list = properties->anchors.anchor_list;

    fprintf(f_config, "n_dim %d\n", n_dim);
    fprintf(f_config, "sys_diameter %10f\n", sys_diameter);
    fprintf(f_config, "sphere_diameter %10f\n", sphere_diameter);


    if (n_anchors > 0) {
        for (i_anchor = 0; i_anchor < n_anchors; ++i_anchor) {
            fprintf(f_config, "anchor");
            for (i = 0; i < n_dim; ++i) {
                fprintf(f_config, " %10f", r_anchor[i_anchor][i]);
            }
            fprintf(f_config, " %10f %10f\n", 
                    properties->anchors.diameter[i_anchor],
                    properties->anchors.k[i_anchor]);

            for (al_list::iterator p = anchor_list[i_anchor].begin();
                 p < anchor_list[i_anchor].end();
                 p++) {
                i_bond = p->label;
                pos = p->pos;

                fprintf(f_config, "bond ");
                for (i = 0; i < n_dim; ++i)
                    fprintf(f_config, "%10f ", 
                            pos[i] + 0.5 * u_bond[i_bond][i] * length[i_bond]);
                for (i = 0; i < n_dim; ++i)
                    fprintf(f_config, "%10f ", u_bond[i_bond][i]);
                fprintf(f_config, "%10f\n", length[i_bond]);
            }
        }
    }
    else {
        for (i_bond = 0; i_bond < n_bonds; ++i_bond) {
            fprintf(f_config, "bond ");
            for (i = 0; i < n_dim; ++i)
                fprintf(f_config, "%10f ", 
                        r_bond[i_bond][i]);
            for (i = 0; i < n_dim; ++i)
                fprintf(f_config, "%10f ", u_bond[i_bond][i]);
            fprintf(f_config, "%10f\n", length[i_bond]);
        }
    }

    for (i_site = n_bonds * 2; i_site < n_sites; ++i_site) {
        fprintf(f_config, "sphere ");
        for (i = 0; i < n_dim; ++i)
            fprintf(f_config, " %10f", r[i_site][i]);
        fprintf(f_config, "\n");
    }
    
                
    fclose(f_config);
}
