/* This routine writes header information for molecular simulations to an output file.
 
 Input: pointer to parameters structure (parameters)
 pointer to properties structure (properties)
 pointer to output file (f_output)
 
 Output: header information is written to the output file */

#include "bob.h"

void write_header_spb_dynamics(system_parameters * parameters,
                                system_properties * properties, FILE * f_output)
{
    int n_dim, n_spheres, n_spheros, n_anchors;

    /* Set up shortcuts to data structures. */
    n_dim = -parameters->n_dim;
    n_spheres = parameters->n_spheres;
    n_spheros = parameters->n_spheros;
    n_anchors = parameters->n_anchors;

    /* Write number of spatial dimensions and number of interaction sites to output file. */
    fwrite(&n_dim, sizeof(int), 1, f_output);
    fwrite(&n_spheres, sizeof(int), 1, f_output);
    fwrite(&n_spheros, sizeof(int), 1, f_output);
    fwrite(&n_anchors, sizeof(int), 1, f_output);

    return;
}
