/* This routine writes the unit cell matrix and site positions to an output file.

   Input: number of spatial dimensions (n_dim)
          number of sites (n_sites)
          unit cell matrix (h)
          array of site positions (r)
          pointer to output file (f_posit)

   Output: the unit cell matrix and site positions are written to the output file */

#include "bob.h"

void write_positions(int n_dim, int n_sites, double **h, double **r, FILE * f_posit)
{
    int i, j, i_site;
    float h_float, r_float;

    /* Write unit cell matrix to output file. */
    for (i = 0; i < n_dim; ++i) {
        for (j = 0; j < n_dim; ++j) {
            h_float = (float) h[i][j];
            fwrite(&h_float, sizeof(float), 1, f_posit);
        }
    }

    /* Write site positions to output file. */
    for (i_site = 0; i_site < n_sites; ++i_site) {
        for (i = 0; i < n_dim; ++i) {
            r_float = (float) r[i_site][i];
            fwrite(&r_float, sizeof(float), 1, f_posit);
        }
    }

    return;
}
