// Implementation for spindle pole body writer for NAB

#include "bob.h"

#include <iostream>

void write_positions_spindle_pole_body(system_parameters *parameters,
                                       system_properties *properties,
                                       FILE *fspb,
                                       bool& write_header) {
    // Get the relevant information
    // First write out writes a header with the information on the relative anchor positions
    if (write_header) {
        // Number of anchors
        int nanchors = properties->anchors.n_anchors;
        fwrite(&nanchors, sizeof(int), 1, fspb);

        // Which anchor has specific properties
        for (int ispb = 0; ispb < nanchors; ++ispb) {
            int nattachments = (int)properties->anchors.anchor_list[ispb].size();
            fwrite(&nattachments, sizeof(int), 1, fspb);

            // Each anchor has a unique label (should correspond to bond), a unique position relative
            // and a unique orientation relative
            for (int ia = 0; ia < nattachments; ++ia) {
                auto p = properties->anchors.anchor_list[ispb][ia];

                int label = p.label;
                fwrite(&label, sizeof(int), 1, fspb);

                float pos[3] = {0.0};
                std::copy(p.pos_rel, p.pos_rel+3, pos);
                fwrite(pos, sizeof(float), 3, fspb);
                std::copy(p.u_rel, p.u_rel+3, pos);
                fwrite(pos, sizeof(float), 3, fspb);
            }
        }

        write_header = false;
    }

    // Write the relevant information for each spindle pole body
    for (int ispb = 0; ispb < properties->anchors.n_anchors; ++ispb) {
        // Write out the coordinates r, u, v, w
        float pos[3] = {0.0};

        double *r_anchor = properties->anchors.r_anchor[ispb];
        double *u_anchor = properties->anchors.u_anchor[ispb];
        double *v_anchor = properties->anchors.v_anchor[ispb];
        double *w_anchor = properties->anchors.w_anchor[ispb];

        std::copy(r_anchor, r_anchor+3, pos);
        fwrite(pos, sizeof(float), 3, fspb);
        std::copy(u_anchor, u_anchor+3, pos);
        fwrite(pos, sizeof(float), 3, fspb);
        std::copy(v_anchor, v_anchor+3, pos);
        fwrite(pos, sizeof(float), 3, fspb);
        std::copy(w_anchor, w_anchor+3, pos);
        fwrite(pos, sizeof(float), 3, fspb);
    }
}
