/* This routine writes various thermodynamic quantities to an output file.

   Input: pointer to parameters structure (parameters)
          pointer to properties structure (properties)
          pointer to potential structure (potential)
          pointer to output file (f_thermo)
nn
   Output: a variety of thermodynamic quantities are written to the output file */

#include "bob.h"

void write_thermo_sphero(system_parameters *parameters,
                         system_properties *properties, 
                         system_potential *potential, 
                         FILE *f_thermo)
{
    int n_dim, n_comp, i, j, i_comp, i_type, n_types;
    double **h, press_ij, volume, dens, u, press_iso, **press_tensor, *u_comp;
    static int first_call = 1;
    
    /* Set up shortcuts to data structures. */
    n_dim = parameters->n_dim;
    h = properties->unit_cell.h;
    volume = properties->thermo.volume;
    dens = properties->thermo.dens;
    u = properties->thermo.u;
    press_iso = properties->thermo.press_iso;
    press_tensor = properties->thermo.press_tensor;
    n_comp = potential->n_comp;
    u_comp = potential->u_comp;
    n_types = properties->crosslinks.n_types_;

    if (first_call) {
        fprintf(f_thermo, "time ");
        for (i = 0; i < n_dim; ++i)
            for (j = 0; j < n_dim; ++j)
                fprintf(f_thermo, "h_%d%d ", i, j);
        fprintf(f_thermo, "volume ");
        fprintf(f_thermo, "dens ");
        fprintf(f_thermo, "u ");
        fprintf(f_thermo, "press_iso ");
        for (i = 0; i < n_dim; ++i)
            for (j = 0; j < n_dim; ++j)
                fprintf(f_thermo, "press_tensor_%d_%d ", i, j);
        for (i = 0; i < n_comp; ++i)
            fprintf(f_thermo, "u_comp_%d ", i);

        for (i_comp = 0; i_comp < n_comp; ++i_comp) {
            for (i = 0; i < n_dim; ++i) {
                for (j = 0; j < n_dim; ++j) {
                    fprintf(f_thermo, "presscomp_%d_%d%d ", i_comp, i, j);
                }
            }
        }
        if (properties->crosslinks.attachment_model_ == 1) {
            fprintf(f_thermo, "n_links n_links_exp ");
        }
        fprintf(f_thermo, "\n");
        
        first_call = 0;
    }

    /* Write various thermodynamic quantities to output file. */
    fprintf(f_thermo, "%g ", properties->time);
    for (i = 0; i < n_dim; ++i)
        for (j = 0; j < n_dim; ++j)
            fprintf(f_thermo, "%g ", h[i][j]);
    fprintf(f_thermo, "%g ", volume);
    fprintf(f_thermo, "%g ", dens);
    fprintf(f_thermo, "%g ", u);
    fprintf(f_thermo, "%g ", press_iso);
    for (i = 0; i < n_dim; ++i)
        for (j = 0; j < n_dim; ++j)
            fprintf(f_thermo, "%g ", press_tensor[i][j]);
    for (i_comp = 0; i_comp < n_comp; ++i_comp)
        fprintf(f_thermo, "%g ", u_comp[i_comp]);

    for (i_comp = 0; i_comp < n_comp; ++i_comp) {
        for (i = 0; i < n_dim; ++i) {
            for (j = 0; j < n_dim; ++j) {
                press_ij = potential->virial_comp[i_comp][i][j];
                press_ij /= volume;
                fprintf(f_thermo, "%g ", press_ij);
            }
        }
    }

    if (properties->crosslinks.attachment_model_ == 1) {
        for (i_type = 0; i_type < n_types; ++i_type)
            fprintf(f_thermo, "%d %g ", properties->crosslinks.n_bound_2_[i_type],
                    properties->crosslinks.n_exp_[i_type]);
    }

    fprintf(f_thermo, "\n");
    fflush(f_thermo);

    return;
}
