%% K14 delete information

clear all;
close all
clc;

NK5 = [0  58 116 174 232 290 348];
NXL = [0 219 438 657 876 1095 1314];
late_length = [0.43757597 0.27157638 0.29583753 0.3942994  0.53449661 0.61627938 ...
    0.75759571 0.26081719 0.35384489 0.82508064 1.10569976 1.02325723 ...
    1.40757142 1.4237511  0.25390396 0.5598386  1.05941884 2.05175096 ...
    2.4484158  2.48806719 2.12501674 0.25418991 0.56475984 1.56337201 ...
    2.46563222 2.72678821 2.5813589  2.45874912 0.25337082 0.56184357 ...
    1.6766894  2.683789   2.74000037 2.74667628 2.71736304 0.25043809 ...
    0.46953846 1.72238832 2.63405082 2.74505222 2.74577357 2.74890414 ...
    0.24718839 0.48776728 2.39358637 2.68080765 2.74765966 2.748867 ...
    2.74678708];
fsb = [1.14654993e-03 0.00000000e+00 5.21159058e-05 2.86637482e-03 ...
 1.71982489e-02 2.59537211e-02 3.92432770e-02 0.00000000e+00 ...
 4.37773609e-03 8.79716489e-02 1.05951636e-01 1.33625182e-01 ...
 9.78736710e-02 1.19345424e-01 0.00000000e+00 1.99082760e-02 ...
 3.00813008e-01 3.88419846e-01 3.09933292e-01 3.85397123e-01 ...
 2.98572024e-01 0.00000000e+00 7.40045862e-03 5.53731499e-01 ...
 5.42005420e-01 5.46435272e-01 5.64519491e-01 3.86647905e-01 ...
 0.00000000e+00 5.94121326e-03 6.45142798e-01 5.77392120e-01 ...
 6.01313321e-01 6.21951220e-01 4.69981238e-01 0.00000000e+00 ...
 3.85657703e-03 6.18146758e-01 5.93287471e-01 6.04283927e-01 ...
 6.20335626e-01 5.49822806e-01 0.00000000e+00 1.66770898e-03 ...
 4.52105483e-01 6.33051907e-01 5.68792996e-01 5.53939962e-01 ...
 5.77548468e-01];

late_length = reshape(late_length, [7, 7]);
fsb = reshape(fsb, [7, 7]);

fig2_k14del_fig = figure;
fig2_k14del_fig.PaperUnits = 'inches';
fig2_k14del_fig.PaperPosition = [0 0 3.0 3.0];

bar_h = bar3(late_length);
c = colorbar;

% Now go through the pain in the ass of recoloring the bars.
cdata_sz = size(bar_h(1).CData);
z_color = repelem(fsb, 6, 4);
z_color = mat2cell(z_color, cdata_sz(1), ones(1, size(late_length,2))*cdata_sz(2));
set(bar_h,{'CData'},z_color.');
zlim([0.0 3.1]);
caxis([0 1]);

xlabel({'Number', 'kinesin-5'});
ylabel({'Number', 'crosslinker'});
zlabel('Late spindle length (\mum)');
ylabel(c,'Fraction simultaneous biorientation','FontSize',18);

% Set all the linewidth, etc
set(gca,'XTickLabel',NK5)
set(gca,'YTickLabel',NXL)
set(gca, 'FontSize', 18);
set(gcf, 'color', 'w');
set(gca, 'LineWidth', 3);

save2pdf('fig2_k14del_base.pdf', fig2_k14del_fig, 600);
%print(gcf, 'fig2_k14del_base.png', '-dpng','-r0')









