%% XL delete information

clear all;
close all
clc;

NK5 = [0 174 348 522 696 870];
NK14 = [0 230 460 690 920 1150];
% This is the original information, with the old K14 characteristic
% distance
late_length = [0.43757597 0.3942994  0.75759571 0.9511821  1.24888096 1.19277887 ...
    0.32978941 0.42118191 0.76625004 1.07776651 1.28267971 1.4800512 ...
    0.27516243 0.48836983 1.11969396 1.24872437 1.43887864 1.18286643 ...
    0.25929962 0.57602751 0.98634479 1.14659071 1.18167701 1.42060338 ...
    0.25231781 0.7228903  0.9956045  1.07673279 1.3978263  1.59846248 ...
    0.24827544 0.78598822 1.32470391 1.51612587 1.79004213 1.94245896];
fsb = [0.00114655 0.00286637 0.03924328 0.05649364 0.05237649 0.08922243 ...
    0.         0.01136127 0.06154888 0.05988118 0.06790703 0.06665624 ...
    0.         0.0327809  0.05711903 0.07343131 0.08718991 0.09766521 ...
    0.         0.02871586 0.09875964 0.09412133 0.1015739  0.09745674 ...
    0.         0.08312487 0.11601001 0.10902647 0.12528664 0.1107463 ...
    0.         0.12346258 0.13331249 0.11288305 0.10855743 0.1130394];

% Need to reverse x and y axes to show properly!
late_length = reshape(late_length, [6, 6])';
fsb = reshape(fsb, [6, 6])';

fig2_xldel_fig = figure;
bar_h = bar3(late_length);
c = colorbar;

% Now go through the pain in the ass of recoloring the bars.
cdata_sz = size(bar_h(1).CData);
z_color = repelem(fsb, 6, 4);
z_color = mat2cell(z_color, cdata_sz(1), ones(1, size(late_length,2))*cdata_sz(2));
set(bar_h,{'CData'},z_color.');
zlim([0.0 3.1]);
caxis([0 1]);

xlabel({'Number', 'kinesin-5'});
ylabel({'Number', 'kinesin-14'});
zlabel('Late spindle length (\mum)');
ylabel(c,'Fraction simultaneous biorientation','FontSize',18);

% Set all the linewidth, etc
set(gca,'XTickLabel',NK5)
set(gca,'YTickLabel',NK14)
set(gca, 'FontSize', 18);
set(gcf, 'color', 'w');
set(gca, 'LineWidth', 3);

fig = gcf;
fig.PaperUnits = 'inches';
fig.PaperPosition = [0 0 3.0 2.0];

save2pdf('fig2_xldel_base.pdf', fig2_xldel_fig, 600);









