%% XL delete information

clear all;
close all
clc;

NK5 = [0 174 348 522 696 870];
NK14 = [0 230 460 690 920 1150];
% This is the version with K14 adjusted characteristic distance
late_length = [0.43550873 0.394248 0.76342493 0.96088934 1.25162, 1.20064 ...
    0.2699353 0.66021603 1.3934876 1.3813179 1.4483043 1.3960457 ...
    0.25069937 0.82656026 1.4138718 1.8825216 1.913544 1.8844895 ...
    0.24516852 0.966203 1.6359469 2.172061 2.2588253 2.1709075 ... 
    0.24244858 0.9940718 2.035867 2.1288416 2.405573 2.2668223 ...
    0.24166884 0.980467 1.74785 2.2441783 2.377748 2.476253];
fsb = [0.0011465499270377321 0.0028663748175943387 0.039243277048155084 0.05649364185949557 0.05237648530331456 0.08922243068584529 ...
    0.0 0.08630393996247653 0.09824322019443969 0.10647279549718579 0.1091307066916823 0.12544298519908276 ...
    0.0 0.21325828642901815 0.24937460913070675 0.18725244944757138 0.16197623514696682 0.12403585574317277 ...
    0.0 0.22305607671461328 0.3538670002084636 0.24744632061705232 0.18464665415884926 0.17036689597665214 ...
    0.0 0.39847821555138635 0.30081300813008127 0.2652178444861372 0.25135501355013545 0.27590160516989787 ...
    0.0 0.3722117990410674 0.4216176777152387 0.34401709401709396 0.19527829893683546 0.2263914946841776];

% Need to reverse x and y axes to show properly!
late_length = reshape(late_length, [6, 6])';
fsb = reshape(fsb, [6, 6])';

fig2_xldel_fig = figure;
bar_h = bar3(late_length);
c = colorbar;

% Now go through the pain in the ass of recoloring the bars.
cdata_sz = size(bar_h(1).CData);
z_color = repelem(fsb, 6, 4);
z_color = mat2cell(z_color, cdata_sz(1), ones(1, size(late_length,2))*cdata_sz(2));
set(bar_h,{'CData'},z_color.');
zlim([0.0 3.1]);
caxis([0 1]);

xlabel({'Number', 'kinesin-5'});
ylabel({'Number', 'kinesin-14'});
zlabel('Late spindle length (\mum)');
ylabel(c,'Fraction simultaneous biorientation','FontSize',18);

% Set all the linewidth, etc
set(gca,'XTickLabel',NK5)
set(gca,'YTickLabel',NK14)
set(gca, 'FontSize', 18);
set(gcf, 'color', 'w');
set(gca, 'LineWidth', 3);

fig = gcf;
fig.PaperUnits = 'inches';
fig.PaperPosition = [0 0 3.0 2.0];

save2pdf('fig2_xldel_base_new.pdf', fig2_xldel_fig, 600);









