%% Semi-flexible membrane with 174 K5 molecules

clear all;
close all
clc;

WF = [0.0 6.08272506083 12.1654501217 18.2481751825 24.3309002433 30.4136253041 36.496350365 42.5790754258 48.6618004866 ...
    54.7445255474 60.8272506082 66.9099756691 72.9927007299 79.0754257907 85.1581508516 91.2408759124 97.3236009732 103.406326034 ...
    109.489051095 115.571776156 121.65450121] * 0.1644;
late_length = [4.182918 3.8637042 3.885448 3.998635 3.8143609 3.8058825 3.7942069 3.6451175 3.6240907 3.618486 3.5106158 3.4148018 ...
    3.6240284 3.7061253 3.365356 3.4190784 3.3308153 3.4116488 3.274529 3.1544995 3.2028656];
late_length_err = [0.30119384200586796 0.22405945227759516 0.30776867466766544 0.1995805737194327 0.20194292350405696 ...
    0.23016117834645025 0.21046011544905555 0.1806915658720059 0.20780358820518136 0.16002782328416407 0.15749573257215482 ...
    0.12830806174199344 0.19690630669896103 0.19825676654961852 0.15162667115815018 0.1617931977544831 0.11525479515592243 0.16999028222730025 ...
    0.17851378891333788 0.1254682091346298 0.09645825438845174];
fsb = [0.5721805294976027 0.5109443402126329 0.5364811340421096 0.5285595163643945 0.5109964561184074 0.5314258911819888 ...
    0.5924015009380862 0.5514905149051491 0.5337189910360641 0.6114238065457577 0.5883885761934543 0.5685324160933917 0.5299666458203044 ...
    0.4986449864498644 0.6623410464873879 0.6259641442568272 0.6042839274546591 0.5805711903272879 0.5562851782363978 0.6372211799041068 0.624296435272045];

% Recale the late_spindle_length_err to be SEM
% In this case, it is already done
%late_length_err = late_length_err / sqrt(12);

supfigfig = figure;
% Set the color properties before we call the errorbar stuff
% bar_h = errorbar(NXL, late_length, late_length_err, 's');
% c = colorbar;

% Use what we know to recolor the whole damn thing
ncolors = size(get(gcf, 'colormap'),1);
z_color = zeros(10,3);
c = colorbar;

cmap = colormap;
L = size(cmap,1);
% Slot in at the appropriate integer location for the colormap
Gs = round(fsb*L);
H = squeeze(reshape(cmap(Gs,:), [size(Gs) 3]));

hold on;
for i=1:length(fsb)
    z_color(i,:) = fsb(i);
    errorbar(WF(i), late_length(i), late_length_err(i), 'Color', H(i,:), ...
        'LineWidth', 3, 'LineStyle', 'none', 'CapSize', 18,...
        'Marker', 's', 'MarkerSize', 18,...
        'MarkerEdgeColor', H(i,:), 'MarkerFaceColor', 'none');
end

xL = get(gca, 'XLim');
plot(xL, [2.75 2.75], 'k--', 'LineWidth', 3);

xlim([-1 WF(20)+1]);
ylim([0 5]);
zlim([0.0 3.1]);
caxis([0 1]);
xlabel({'Asymptotic wall force (pN)'});
ylabel({'Late spindle length (\mum)'});
ylabel(c,'Fraction simultaneous biorientation','FontSize',18);

% Set all the linewidth, etc
%set(gca,'XTickLabel',NXL)
set(gca, 'FontSize', 18);
set(gcf, 'color', 'w');
set(gca, 'LineWidth', 3);

fig = gcf;
fig.PaperUnits = 'inches';
fig.PaperPosition = [0 0 3.0 2.0];

save2pdf('fig2_semiflexiblene_17pn_base.pdf', supfigfig, 600);









