#!/usr/bin/env python
# In case of poor (Sh**y) commenting contact adam.lamson@colorado.edu
# Basic
import sys, os, pdb
import gc
from collections import OrderedDict
## Analysis
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Lib'))
sys.path.append(os.path.join(os.path.dirname(__file__), '..', '..', '..', 'Spindle'))
from stylelib.ase1_styles import cp_spindle_stl
from spindle_unit_dict import SpindleUnitDict, ModifyXLabel

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
from mpl_toolkits.axes_grid1 import make_axes_locatable
import itertools
# from math import *

# Read in a dictionary of the entire run set
chromosome_seconds_abkf = {0.0: [0.22951844903064417, 0.6716697936210133, 0.31269543464665417, 0.2639149468417762, 0.13570981863664788, 0.21013133208255166, 0.2707942464040027, 0.4859287054409005, 0.5021888680425269, 0.15509693558474053, 0.41025641025640996, 0.11319574734208868], 0.14796: [0.28267667292057547, 0.432145090681676, 0.06504065040650417, 0.017510944340212616, 0.0, 0.75422138836773, 0.3908692933083178, 0.1857410881801127, 0.26704190118824256, 0.2945590994371485, 0.1938711694809255, 0.5572232645403377], 0.03288: [0.1788617886178863, 0.27016885553470915, 0.24140087554721693, 0.3808630393996247, 0.3564727954971858, 0.05128205128205124, 0.404002501563477, 0.3114446529080676, 0.40400250156347706, 0.30894308943089427, 0.28392745465916197, 0.19262038774233886], 0.06576: [0.30393996247654786, 0.19387116948092573, 0.7329580988117573, 0.6366479049405879, 0.13883677298311434, 0.19262038774233875, 0.20325203252032525, 0.2020012507817387, 0.26078799249530976, 0.27454659161976264, 0.38023764853033115, 0.08692933083177], 0.11508: [0.12570356472795496, 0.18511569731081914, 0.11257035647279538, 0.3733583489681051, 0.7942464040025016, 0.10381488430268904, 0.3389618511569729, 0.35897435897435903, 0.15384615384615374, 0.8142589118198875, 0.7010631644777986, 0.21638524077548466], 0.09864: [0.5440900562851783, 0.5753595997498436, 0.6704190118824265, 0.30581613508442773, 0.26328955597248277, 0.5440900562851784, 0.8142589118198875, 0.09068167604753, 0.22013758599124456, 0.6679174484052532, 0.2539086929330832, 0.39837398373983746], 0.13152: [0.2933083176985616, 0.15384615384615383, 0.2589118198874297, 0.10131332082551595, 0.1332082551594747, 0.6110068792995624, 0.3671044402751719, 0.4133833646028765, 0.28767979987492165, 0.16197623514696685, 0.19512195121951229, 0.13320825515947451], 0.1644: [0.015009380863039375, 0.23389618511569737, 0.0931832395247028, 0.03126954346466525, 0.49405878674171355, 0.24390243902439035, 0.11319574734208881, 0.19324577861163217, 0.2539086929330831, 0.16135084427767352, 0.2363977485928706, 0.07692307692307694], 0.04932: [0.25203252032520335, 0.2564102564102564, 0.27767354596622895, 0.24077548467792378, 0.150093808630394, 0.30706691682301446, 0.46904315196998136, 0.23264540337711087, 0.27642276422764234, 0.2926829268292683, 0.3339587242026267, 0.21450906816760476], 0.0822: [0.27329580988117563, 0.0, 0.03627267041901188, 0.2414008755472173, 0.32457786116322684, 0.6435272045028143, 0.25641025641025633, 0.6929330831769857, 0.5259537210756724, 0.15697310819262028, 0.21200750469043164, 0.16197623514696693], 0.01644: [0.3414634146341464, 0.1425891181988742, 0.2839274546591618, 0.4615384615384616, 0.30706691682301435, 0.31332082551594725, 0.43777360850531594, 0.6091307066916825, 0.13008130081300814, 0.33771106941838663, 0.4496560350218891, 0.6460287679799877]}
print chromosome_seconds_abkf

# Create a set of arrays with the setup of the force, rather than alpha (inverse-force)
x_vals_orig = np.zeros(11, dtype=np.float64)
y_vals_orig = np.zeros(11, dtype=np.float64)
y_errs_orig = np.zeros(11, dtype=np.float64)
ival = 0
for key,val in chromosome_seconds_abkf.iteritems():
    # Redo the key value
    x_vals_orig[ival] = np.float64(np.float64(1.0) / np.float64(key) * np.float64(0.1644))
    y_vals_orig[ival] = np.mean(val)
    y_errs_orig[ival] = np.std(val, ddof=1) / np.sqrt(len(val))
    ival += 1

print x_vals_orig
print y_vals_orig
print y_errs_orig

# replace the x value at infinity with a suitably large number
x_vals_orig[0] = 40000.

x_vals = [x for _, x in sorted(zip(x_vals_orig, x_vals_orig))]
y_vals = [x for _, x in sorted(zip(x_vals_orig, y_vals_orig))]
y_errs = [x for _, x in sorted(zip(x_vals_orig, y_errs_orig))]

print x_vals
print y_vals
print y_errs

# based on Adam's gridspec schenanigans, to make pretty broken plots
xticks = np.unique(x_vals)
l, m = (float(len(xticks)-1), 1.0)

# This is a oneoff, just make the damn plot!
plt.style.use(cp_spindle_stl)
mpl.rcParams['font.serif'] = 'Arial'
mpl.rcParams['font.sans-serif'] = 'Arial'

fig, axarr = plt.subplots(1, 2, figsize=(2.5, 2.5), sharey=True, gridspec_kw = {'width_ratios':[l,m]})
# Set the logx if we want
axarr[0].set_xscale('log')

# Plot the same values on both axes
axarr[0].scatter(x_vals[0:-1], y_vals[0:-1], zorder=100, s=50, marker='s', color='k', label=None, facecolors='none')
axarr[0].errorbar(x_vals[0:-1], y_vals[0:-1], y_errs[0:-1], ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')
axarr[1].scatter([x_vals[-1]], [y_vals[-1]], zorder=100, s=50, marker='s', color='k', label=None, facecolors='none')
axarr[1].errorbar([x_vals[-1]], [y_vals[-1]], [y_errs[-1]], ecolor='k', elinewidth=2, capsize=5, capthick=1, zorder=0, fmt='none', marker='s')

axarr[0].set_ylim(0.0, 0.6)
axarr[1].set_ylim(0.0, 0.6)
#axarr[0].set_xlim(0.0, 12.0)
axarr[0].set_xlim(0.9, 11.0)
axarr[1].set_xlim(39999,40001)


# Adjust the visibility of stuff on the plots
axarr[0].spines['right'].set_visible(False)
axarr[1].spines['left'].set_visible(False)
#axarr[1].spines['right'].set_visible(False)

axarr[0].tick_params(labelright=False)
axarr[1].tick_params(labelleft=False)
axarr[1].yaxis.tick_right()
axarr[1].tick_params(right=False)
plt.subplots_adjust(wspace=0.05, bottom=0.16)

# Create the breaks
d = 0.01
kwargs = dict(transform=axarr[0].transAxes, color='k', clip_on=False)
olm = (l+m)/l; oml = (m+l)/m;
axarr[0].plot((1-d*olm,1+d*olm),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
axarr[0].plot((1-d*olm,1+d*olm),(1-d,1+d), linewidth=1, **kwargs) # top-left diagonal
kwargs.update(transform=axarr[1].transAxes) # switch to the bottom axes
axarr[1].plot((-d*oml,d*oml),(-d,d), linewidth=1, **kwargs) # bottom-left diagonal
axarr[1].plot((-d*oml,d*oml),(1-d,1+d), linewidth=1, **kwargs) # top-left diagonal

axarr[1].xaxis.set_ticks([40000])
axarr[1].set_xticklabels(['$\infty$'])
ModifyXLabel(axarr[0], 'abkf')
axarr[0].set_ylabel(r'Fraction simultaneous biorientation')

fig.tight_layout()
plt.savefig('fig3_forcedepabk.pdf', dpi=fig.dpi)
plt.close()

# Now make the force curve for the best f0
index_max = np.argmax(y_vals)
print "index_best = {}".format(index_max)
# This is the pN of the best one
F0 = x_vals[index_max]
print "F0 = {} pN".format(F0)
fig, ax = plt.subplots(figsize=(2.5,2.5))

xvals = np.arange(0.0, 5.0, 0.02)
plt.plot(xvals, 1.0 / (1.0 + xvals/F0), color='k', linewidth=2)

# Set limits first
ax.set_ylim(0.0, 1.0)
ax.set_xlim(0.0, 5.0)

# Draw lines for the force
plt.axvline(x=F0, ymin=0., ymax=0.5, color='r', linewidth=2, linestyle='--')
plt.axhline(y=0.5, xmin=0., xmax=(F0/5.0), color='r', linewidth=2, linestyle='--')

ModifyXLabel(ax, 'ikctension')
ax.set_ylabel(r'Stabilization factor')

fig.tight_layout()
plt.savefig('fig3_forcedepcurve.pdf', dpi=fig.dpi)
plt.close()
