function [T] = time_six(rates)
% compute the mean time to decision for a given architecture with rates as
% input and activation rule k=6. We define the transfer matrices L with
% sinks. We then compute the statistics of the OFF to ON times (the ON to
% OFF times are trivial). From there we compute the drift per cycle vdt and
% then the mean FPT T.
% 
P=rates(1:6);
NU=rates(7:12);
L=1;
transfer=[-P(1)*L NU(1) 0 0 0 0 0;P(1)*L -NU(1)-P(2)*L NU(2) 0 0 0 0;0 P(2)*L -NU(2)-P(3)*L NU(3) 0 0 0;0 0 P(3)*L -NU(3)-P(4)*L NU(4) 0 0; 0 0 0 P(4)*L -NU(4)-P(5)*L NU(5) 0; 0 0 0 0 P(5)*L -NU(5)-P(6)*L NU(6); 0 0 0 0 0 P(6)*L -NU(6)];
e=0.32;
kplus=(1-e)/e;
K=log(kplus);
L0=1;
L=L0*1.05;
trans=[-P(1)*L NU(1) 0 0 0 0 0;P(1)*L -NU(1)-P(2)*L NU(2) 0 0 0 0;0 P(2)*L -NU(2)-P(3)*L NU(3) 0 0 0;0 0 P(3)*L -NU(3)-P(4)*L NU(4) 0 0; 0 0 0 P(4)*L -NU(4)-P(5)*L 0 0; 0 0 0 0 P(5)*L -NU(5)-P(6)*L 0; 0 0 0 0 0 P(6)*L 0];
L=L0*1.05;
trans1=[-P(1)*L NU(1) 0 0 0 0 0;P(1)*L -NU(1)-P(2)*L NU(2) 0 0 0 0;0 P(2)*L -NU(2)-P(3)*L NU(3) 0 0 0;0 0 P(3)*L -NU(3)-P(4)*L NU(4) 0 0; 0 0 0 P(4)*L -NU(4)-P(5)*L 0 0; 0 0 0 0 P(5)*L -NU(5)-P(6)*L 0; 0 0 0 0 0 P(6)*L 0];
L=L0*0.95;
trans2=[-P(1)*L NU(1) 0 0 0 0 0;P(1)*L -NU(1)-P(2)*L NU(2) 0 0 0 0;0 P(2)*L -NU(2)-P(3)*L NU(3) 0 0 0;0 0 P(3)*L -NU(3)-P(4)*L NU(4) 0 0; 0 0 0 P(4)*L -NU(4)-P(5)*L 0 0; 0 0 0 0 P(5)*L -NU(5)-P(6)*L 0; 0 0 0 0 0 P(6)*L 0];
maxou=1/( min([  abs(nonzeros(eig(trans))); abs(nonzeros(eig(trans1))); abs(nonzeros(eig(trans2)))]) );
dt=0.01;
if maxou>1000
    dt=0.1;
end
if maxou>10000
    dt=1;
end

X=[1:(maxou/dt)]*dt;
W=[];
W1=[];
W2=[];
for i=1:numel(X)
    W(i)= [0 0 0 0 0 0 1]*trans*expm(trans*X(i))*[0;0;0;0;0;1;0];
end
for i=1:numel(X)
    W1(i)= [0 0 0 0 0 0 1]*trans1*expm(trans1*X(i))*[0; 0; 0; 0; 0;1;0];
end
for i=1:numel(X)
    W2(i)= [0 0 0 0 0 0 1]*trans2*expm(trans2*X(i))*[0;0; 0; 0; 0;1;0];
end
testit=min([min(find(W==0)),min(find(W1==0)),min(find(W2==0))])-1;
maxou=(testit*dt)*0.8;
dt=0.01;
if maxou>1000
    dt=0.1;
end
if maxou>10000
    dt=1; 
end

X=[1:(maxou/dt)]*dt;
W=[];
W1=[];
W2=[];
for i=1:numel(X)
    W(i)= [0 0 0 0 0 0 1]*trans*expm(trans*X(i))*[0;0;0;0;0;1;0];
end
for i=1:numel(X)
    W1(i)= [0 0 0 0 0 0 1]*trans1*expm(trans1*X(i))*[0; 0; 0; 0; 0;1;0];
end
for i=1:numel(X)
    W2(i)= [0 0 0 0 0 0 1]*trans2*expm(trans2*X(i))*[0;0; 0; 0; 0;1;0];
end
Y= dt*W.*log( W1./W2);
vdt=sum(Y);
Y= dt*W.*(log( W1./W2  ).^2);
vdt=2*vdt;
Y=dt*W.*X;
T= (sum(Y)+1/NU(6))*K*tanh(K/2)/abs(vdt);
end

