
library(randomForest)
library(pROC)

iterative_rf_fixed_size_with_null_distribution = function(data,window1,window2,disease,control,iter,trainsize,testsize)
{
	set.seed(150);
	featureProfile <- as.data.frame(matrix(NA,iter,ncol(data)));
	AUCArraySelf <- NULL;
	SensitivityArraySelf <- NULL;
	SpecificityArraySelf <- NULL;
	AUCArrayNonSelf <- NULL;
	SensitivityArrayNonSelf <- NULL;
	SpecificityArrayNonSelf <- NULL;
	AUCArrayNull1 <- NULL;
	SensitivityNull1 <- NULL;
	SpecificityNull1 <- NULL;
	AUCArrayNull1 <- NULL;
	SensitivityArrayNull1 <- NULL;
	SpecificityArrayNull1 <- NULL;
	AUCArrayNull2 <- NULL;
	SensitivityArrayNull2 <- NULL;
	SpecificityArrayNull2 <- NULL;
	#threshold <- ifelse(length(intersect(window,disease)) <= 20,10,20);
	for(i in 1:iter)
	{
		if(length(intersect(window1,disease)) > trainsize)
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=FALSE);
		}
		else
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=TRUE);
		}

		if(length(intersect(window1,control)) > trainsize)
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=FALSE);
		}
		else
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=TRUE);
		}
		tempTrain <- rbind(data[trainDisease,],data[trainControl,]);
		rownames(tempTrain) <- make.names(rownames(tempTrain),unique=TRUE);
		TrainDiseaseTags <- NULL;
		TrainDiseaseTags[1:length(trainDisease)] <- "Diseased";
		TrainControlTags <- NULL;
		TrainControlTags[1:length(trainControl)] <- "Control";
		TrainTags <- c(TrainDiseaseTags,TrainControlTags);
		rfTempComp <- randomForest(as.factor(TrainTags)~.,tempTrain);
		#print("model created");
		featureProfile[i,] <- sapply(colnames(tempTrain),function(x)(ifelse(x %in% rownames(rfTempComp$importance),rfTempComp$importance[x,],0)));
		if(length(setdiff(intersect(window1,disease),trainDisease)) > testsize)
		{
			testDiseaseSelf <- sample(setdiff(intersect(window1,disease),trainDisease),testsize,replace=FALSE);
		}
		else
		{
			testDiseaseSelf <- sample(setdiff(intersect(window1,disease),trainDisease),testsize,replace=TRUE);
		}

		if(length(setdiff(intersect(window1,control),trainControl)) > testsize)
		{
			testControlSelf <- sample(setdiff(intersect(window1,control),trainControl),testsize,replace=FALSE);
		}
		else
		{
			testControlSelf <- sample(setdiff(intersect(window1,control),trainControl),testsize,replace=TRUE);
		}

		if(length(intersect(window2,disease)) > testsize)
		{
			testDiseaseNonSelf <- sample(intersect(window2,disease),testsize,replace=FALSE);
		}
		else
		{
			testDiseaseNonSelf <- sample(intersect(window2,disease),testsize,replace=TRUE);
		}
		
		if(length(intersect(window2,control)) > testsize)
		{
			testControlNonSelf <- sample(intersect(window2,control),testsize,replace=FALSE);
		}
		else
		{
			testControlNonSelf <- sample(intersect(window2,control),testsize,replace=TRUE);
		}
		tempTestSelf <- rbind(data[testDiseaseSelf,],data[testControlSelf,]);
		TestDiseaseTags <- NULL;
		TestDiseaseTags[1:length(testDiseaseSelf)] <- "Diseased";
		TestControlTags <- NULL;
		TestControlTags[1:length(testControlSelf)] <- "Control";
		TestTags <- c(TestDiseaseTags,TestControlTags);
		rownames(tempTestSelf) <- make.names(rownames(tempTestSelf),unique=TRUE);
		rfTempPredictSelf <- predict(rfTempComp,tempTestSelf,type="vote",norm.votes=TRUE);
		AUCArraySelf[i] <- auc(TestTags,rfTempPredictSelf[,2])[1];
		SensitivityArraySelf[i] <- length(which(predict(rfTempComp,tempTestSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestSelf[1:testsize,]));
		SpecificityArraySelf[i] <- length(which(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),])=="Control"))/length(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),]));
		
		tempTestNonSelf <- rbind(data[testDiseaseNonSelf,],data[testControlNonSelf,]);
		print(testDiseaseSelf)
		TestDiseaseTags <- NULL;
		TestDiseaseTags[1:length(testDiseaseNonSelf)] <- "Diseased";
		TestControlTags <- NULL;
		TestControlTags[1:length(testControlNonSelf)] <- "Control";
		TestTags <- c(TestDiseaseTags,TestControlTags);
		rownames(tempTestNonSelf) <- make.names(rownames(tempTestNonSelf),unique=TRUE);
		rfTempPredictNonSelf <- predict(rfTempComp,tempTestNonSelf,type="vote",norm.votes=TRUE);
		print(i);
		AUCArrayNonSelf[i] <- auc(TestTags,rfTempPredictNonSelf[,2])[1];
		
		SensitivityArrayNonSelf[i] <- length(which(predict(rfTempComp,tempTestNonSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNonSelf[1:testsize,]));
		SpecificityArrayNonSelf[i] <- length(which(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),])=="Control"))/length(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),]));
		
		testDiseaseNull1 <- sample(permute(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)
		testControlNull1 <- sample(permute(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
		
		tempTestNull1 <- rbind(data[testDiseaseNull1,],data[testControlNull1,]);
		TestDiseaseTags <- NULL;
		TestDiseaseTags[1:length(testDiseaseNull1)] <- "Diseased";
		TestControlTags <- NULL;
		TestControlTags[1:length(testControlNull1)] <- "Control";
		TestTags <- c(TestDiseaseTags,TestControlTags);
		rownames(tempTestNull1) <- make.names(rownames(tempTestNull1),unique=TRUE);
		rfTempPredictNull1 <- predict(rfTempComp,tempTestNull1,type="vote",norm.votes=TRUE);
		print(i);
		AUCArrayNull1[i] <- auc(TestTags,rfTempPredictNull1[,2])[1];
		SensitivityArrayNull1[i] <- length(which(predict(rfTempComp,tempTestNull1[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull1[1:testsize,]));
		SpecificityArrayNull1[i] <- length(which(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),])=="Control"))/length(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),]));

		testDiseaseNull2 <- sample(permute(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)
		testControlNull2 <- sample(permute(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
		
		tempTestNull2 <- rbind(data[testDiseaseNull2,],data[testControlNull2,]);
		TestDiseaseTags <- NULL;
		TestDiseaseTags[1:length(testDiseaseNull2)] <- "Diseased";
		TestControlTags <- NULL;
		TestControlTags[1:length(testControlNull2)] <- "Control";
		TestTags <- c(TestDiseaseTags,TestControlTags);
		rownames(tempTestNull2) <- make.names(rownames(tempTestNull2),unique=TRUE);
		rfTempPredictNull2 <- predict(rfTempComp,tempTestNull2,type="vote",norm.votes=TRUE);
		print(i);
		AUCArrayNull2[i] <- auc(TestTags,rfTempPredictNull2[,2])[1];
		
		SensitivityArrayNull2[i] <- length(which(predict(rfTempComp,tempTestNull2[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull2[1:testsize,]));
		SpecificityArrayNull2[i] <- length(which(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),])=="Control"))/length(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),]));		
		
		i <- i + 1;
	}
	colnames(featureProfile) <- colnames(tempTrain);
	#returnList <- list("featureProfile"=featureProfile,"AUC"=AUCArray,"Accuracy"=AccuracyArray);
	returnList <- list("AUCSameAge"=AUCArraySelf,"SensitivitySameAge"=SensitivityArraySelf,"SpecificitySameAge"=SpecificityArraySelf,"AUCDiffAge"=AUCArrayNonSelf,"SensitivityDiffAge"=SensitivityArrayNonSelf,"SpecificityDiffAge"=SpecificityArrayNonSelf,"AUCNull1"=AUCArrayNull1,"SensitivityNull1"=SensitivityArrayNull1,"SpecificityNull1"=SpecificityArrayNull1,"AUCNull2"=AUCArrayNull2,"SensitivityNull2"=SensitivityArrayNull2,"SpecificityNull2"=SpecificityArrayNull2,"featureProfile"=featureProfile);
	return(returnList);
		
}

iterative_rf_multiple_with_null_distribution = function(data,window1,window2,disease,control,training_iter,testing_iter,trainsize,testsize)
{
	set.seed(150);
	featureProfile <- as.data.frame(matrix(NA,training_iter,ncol(data)));
	AUCArraySelf <- matrix(NA,training_iter,testing_iter)
	SensitivityArraySelf <- matrix(NA,training_iter,testing_iter)
	SpecificityArraySelf <- matrix(NA,training_iter,testing_iter)
	AUCArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SensitivityNull1 <- matrix(NA,training_iter,testing_iter)
	SpecificityNull1 <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNull1 <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull2 <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNull2 <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNull2 <- matrix(NA,training_iter,testing_iter)
	#threshold <- ifelse(length(intersect(window,disease)) <= 20,10,20);
	for(i in 1:training_iter)
	{
		if(length(intersect(window1,disease)) > trainsize)
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=FALSE);
		}
		else
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=TRUE);
		}

		if(length(intersect(window1,control)) > trainsize)
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=FALSE);
		}
		else
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=TRUE);
		}
		tempTrain <- rbind(data[trainDisease,],data[trainControl,]);
		rownames(tempTrain) <- make.names(rownames(tempTrain),unique=TRUE);
		TrainDiseaseTags <- NULL;
		TrainDiseaseTags[1:length(trainDisease)] <- "Diseased";
		TrainControlTags <- NULL;
		TrainControlTags[1:length(trainControl)] <- "Control";
		TrainTags <- c(TrainDiseaseTags,TrainControlTags);
		rfTempComp <- randomForest(as.factor(TrainTags)~.,tempTrain);
		#print("model created");
		featureProfile[i,] <- sapply(colnames(tempTrain),function(x)(ifelse(x %in% rownames(rfTempComp$importance),rfTempComp$importance[x,],0)));
		for(k in 1:testing_iter)
		{
			if(length(setdiff(intersect(window1,disease),trainDisease)) > testsize)
			{
				testDiseaseSelf <- sample(setdiff(intersect(window1,disease),trainDisease),testsize,replace=FALSE);
			}
			else
			{
				testDiseaseSelf <- sample(setdiff(intersect(window1,disease),trainDisease),testsize,replace=TRUE);
			}

			if(length(setdiff(intersect(window1,control),trainControl)) > testsize)
			{
				testControlSelf <- sample(setdiff(intersect(window1,control),trainControl),testsize,replace=FALSE);
			}
			else
			{
				testControlSelf <- sample(setdiff(intersect(window1,control),trainControl),testsize,replace=TRUE);
			}

			if(length(intersect(window2,disease)) > testsize)
			{
				testDiseaseNonSelf <- sample(intersect(window2,disease),testsize,replace=FALSE);
			}
			else
			{
				testDiseaseNonSelf <- sample(intersect(window2,disease),testsize,replace=TRUE);
			}
		
			if(length(intersect(window2,control)) > testsize)
			{
				testControlNonSelf <- sample(intersect(window2,control),testsize,replace=FALSE);
			}
			else
			{
				testControlNonSelf <- sample(intersect(window2,control),testsize,replace=TRUE);
			}
			tempTestSelf <- rbind(data[testDiseaseSelf,],data[testControlSelf,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseSelf)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlSelf)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestSelf) <- make.names(rownames(tempTestSelf),unique=TRUE);
			rfTempPredictSelf <- predict(rfTempComp,tempTestSelf,type="vote",norm.votes=TRUE);
			print(i)
			print(k)
			AUCArraySelf[i,k] <- auc(TestTags,rfTempPredictSelf[,2])[1];
			print(AUCArraySelf[i,k])
			SensitivityArraySelf[i,k] <- length(which(predict(rfTempComp,tempTestSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestSelf[1:testsize,]));
			SpecificityArraySelf[i,k] <- length(which(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),])=="Control"))/length(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),]));
		
			tempTestNonSelf <- rbind(data[testDiseaseNonSelf,],data[testControlNonSelf,]);
			#print(testDiseaseSelf)
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNonSelf)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNonSelf)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNonSelf) <- make.names(rownames(tempTestNonSelf),unique=TRUE);
			rfTempPredictNonSelf <- predict(rfTempComp,tempTestNonSelf,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNonSelf[i,k] <- auc(TestTags,rfTempPredictNonSelf[,2])[1];
			print(AUCArrayNonSelf[i,k])
			SensitivityArrayNonSelf[i,k] <- length(which(predict(rfTempComp,tempTestNonSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNonSelf[1:testsize,]));
			SpecificityArrayNonSelf[i,k] <- length(which(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),])=="Control"))/length(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),]));
			
			
			testDiseaseNull1 <- sample(sample(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)
			testControlNull1 <- sample(sample(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
			
			tempTestNull1 <- rbind(data[testDiseaseNull1,],data[testControlNull1,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNull1)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNull1)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNull1) <- make.names(rownames(tempTestNull1),unique=TRUE);
			rfTempPredictNull1 <- predict(rfTempComp,tempTestNull1,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNull1[i,k] <- auc(TestTags,rfTempPredictNull1[,2])[1];
			print(AUCArrayNull1[i,k])
			SensitivityArrayNull1[i,k] <- length(which(predict(rfTempComp,tempTestNull1[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull1[1:testsize,]));
			SpecificityArrayNull1[i,k] <- length(which(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),])=="Control"))/length(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),]));

			testDiseaseNull2 <- sample(sample(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)	
			testControlNull2 <- sample(sample(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
		
			tempTestNull2 <- rbind(data[testDiseaseNull2,],data[testControlNull2,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNull2)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNull2)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNull2) <- make.names(rownames(tempTestNull2),unique=TRUE);
			rfTempPredictNull2 <- predict(rfTempComp,tempTestNull2,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNull2[i,k] <- auc(TestTags,rfTempPredictNull2[,2])[1];
			SensitivityArrayNull2[i,k] <- length(which(predict(rfTempComp,tempTestNull2[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull2[1:testsize,]));
			SpecificityArrayNull2[i,k] <- length(which(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),])=="Control"))/length(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),]));	

			k <- k + 1;
		}	
		
		i <- i + 1;
	}
	colnames(featureProfile) <- colnames(tempTrain);
	#returnList <- list("featureProfile"=featureProfile,"AUC"=AUCArray,"Accuracy"=AccuracyArray);
	returnList <- list("AUCSameAge"=AUCArraySelf,"SensitivitySameAge"=SensitivityArraySelf,"SpecificitySameAge"=SpecificityArraySelf,"AUCDiffAge"=AUCArrayNonSelf,"SensitivityDiffAge"=SensitivityArrayNonSelf,"SpecificityDiffAge"=SpecificityArrayNonSelf,"AUCNull1"=AUCArrayNull1,"SensitivityNull1"=SensitivityArrayNull1,"SpecificityNull1"=SpecificityArrayNull1,"AUCNull2"=AUCArrayNull2,"SensitivityNull2"=SensitivityArrayNull2,"SpecificityNull2"=SpecificityArrayNull2,"featureProfile"=featureProfile);

	return(returnList);
		
}

iterative_rf_multiple_valid_with_null_distribution = function(data,window1,window2,window3,disease,control,training_iter,testing_iter,trainsize,testsize)
{
	set.seed(150);
	featureProfile <- as.data.frame(matrix(NA,training_iter,ncol(data)));
	AUCArraySelf <- matrix(NA,training_iter,testing_iter)
	SensitivityArraySelf <- matrix(NA,training_iter,testing_iter)
	SpecificityArraySelf <- matrix(NA,training_iter,testing_iter)
	AUCArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNonSelf <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SensitivityNull1 <- matrix(NA,training_iter,testing_iter)
	SpecificityNull1 <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNull1 <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNull1 <- matrix(NA,training_iter,testing_iter)
	AUCArrayNull2 <- matrix(NA,training_iter,testing_iter)
	SensitivityArrayNull2 <- matrix(NA,training_iter,testing_iter)
	SpecificityArrayNull2 <- matrix(NA,training_iter,testing_iter)
	#threshold <- ifelse(length(intersect(window,disease)) <= 20,10,20);
	for(i in 1:training_iter)
	{
		if(length(intersect(window1,disease)) > trainsize)
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=FALSE);
		}
		else
		{
			trainDisease <- sample(intersect(window1,disease),trainsize,replace=TRUE);
		}

		if(length(intersect(window1,control)) > trainsize)
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=FALSE);
		}
		else
		{
			trainControl <- sample(intersect(window1,control),trainsize,replace=TRUE);
		}
		tempTrain <- rbind(data[trainDisease,],data[trainControl,]);
		rownames(tempTrain) <- make.names(rownames(tempTrain),unique=TRUE);
		TrainDiseaseTags <- NULL;
		TrainDiseaseTags[1:length(trainDisease)] <- "Diseased";
		TrainControlTags <- NULL;
		TrainControlTags[1:length(trainControl)] <- "Control";
		TrainTags <- c(TrainDiseaseTags,TrainControlTags);
		rfTempComp <- randomForest(as.factor(TrainTags)~.,tempTrain);
		#print("model created");
		featureProfile[i,] <- sapply(colnames(tempTrain),function(x)(ifelse(x %in% rownames(rfTempComp$importance),rfTempComp$importance[x,],0)));
		for(k in 1:testing_iter)
		{
			if(length(intersect(window2,disease)) > testsize)
			{
				testDiseaseSelf <- sample(intersect(window2,disease),testsize,replace=FALSE);
			}
			else
			{
				testDiseaseSelf <- sample(intersect(window2,disease),testsize,replace=TRUE);
			}
		
			if(length(intersect(window2,control)) > testsize)
			{
				testControlSelf <- sample(intersect(window2,control),testsize,replace=FALSE);
			}
			else
			{
				testControlSelf <- sample(intersect(window2,control),testsize,replace=TRUE);
			}

			if(length(intersect(window3,disease)) > testsize)
			{
				testDiseaseNonSelf <- sample(intersect(window3,disease),testsize,replace=FALSE);
			}
			else
			{
				testDiseaseNonSelf <- sample(intersect(window3,disease),testsize,replace=TRUE);
			}
		
			if(length(intersect(window3,control)) > testsize)
			{
				testControlNonSelf <- sample(intersect(window3,control),testsize,replace=FALSE);
			}
			else
			{
				testControlNonSelf <- sample(intersect(window3,control),testsize,replace=TRUE);
			}
			tempTestSelf <- rbind(data[testDiseaseSelf,],data[testControlSelf,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseSelf)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlSelf)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestSelf) <- make.names(rownames(tempTestSelf),unique=TRUE);
			rfTempPredictSelf <- predict(rfTempComp,tempTestSelf,type="vote",norm.votes=TRUE);
			print(i)
			print(k)
			AUCArraySelf[i,k] <- auc(TestTags,rfTempPredictSelf[,2])[1];
			SensitivityArraySelf[i,k] <- length(which(predict(rfTempComp,tempTestSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestSelf[1:testsize,]));
			SpecificityArraySelf[i,k] <- length(which(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),])=="Control"))/length(predict(rfTempComp,tempTestSelf[(testsize+1):nrow(tempTestSelf),]));
		
			tempTestNonSelf <- rbind(data[testDiseaseNonSelf,],data[testControlNonSelf,]);
			#print(testDiseaseSelf)
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNonSelf)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNonSelf)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNonSelf) <- make.names(rownames(tempTestNonSelf),unique=TRUE);
			rfTempPredictNonSelf <- predict(rfTempComp,tempTestNonSelf,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNonSelf[i,k] <- auc(TestTags,rfTempPredictNonSelf[,2])[1];
			SensitivityArrayNonSelf[i,k] <- length(which(predict(rfTempComp,tempTestNonSelf[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNonSelf[1:testsize,]));
			SpecificityArrayNonSelf[i,k] <- length(which(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),])=="Control"))/length(predict(rfTempComp,tempTestNonSelf[(testsize+1):nrow(tempTestNonSelf),]));

			testDiseaseNull1 <- sample(sample(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)
			testControlNull1 <- sample(sample(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
		
			tempTestNull1 <- rbind(data[testDiseaseNull1,],data[testControlNull1,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNull1)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNull1)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNull1) <- make.names(rownames(tempTestNull1),unique=TRUE);
			rfTempPredictNull1 <- predict(rfTempComp,tempTestNull1,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNull1[i,k] <- auc(TestTags,rfTempPredictNull1[,2])[1];
			SensitivityArrayNull1[i,k] <- length(which(predict(rfTempComp,tempTestNull1[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull1[1:testsize,]));
			SpecificityArrayNull1[i,k] <- length(which(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),])=="Control"))/length(predict(rfTempComp,tempTestNull1[(testsize+1):nrow(tempTestNull1),]));

			testDiseaseNull2 <- sample(sample(c(testDiseaseSelf,testDiseaseNonSelf)),testsize,replace=FALSE)	
			testControlNull2 <- sample(sample(c(testControlSelf,testControlNonSelf)),testsize,replace=FALSE)
		
			tempTestNull2 <- rbind(data[testDiseaseNull2,],data[testControlNull2,]);
			TestDiseaseTags <- NULL;
			TestDiseaseTags[1:length(testDiseaseNull2)] <- "Diseased";
			TestControlTags <- NULL;
			TestControlTags[1:length(testControlNull2)] <- "Control";
			TestTags <- c(TestDiseaseTags,TestControlTags);
			rownames(tempTestNull2) <- make.names(rownames(tempTestNull2),unique=TRUE);
			rfTempPredictNull2 <- predict(rfTempComp,tempTestNull2,type="vote",norm.votes=TRUE);
			#print(k);
			AUCArrayNull2[i,k] <- auc(TestTags,rfTempPredictNull2[,2])[1];
			SensitivityArrayNull2[i,k] <- length(which(predict(rfTempComp,tempTestNull2[1:testsize,])=="Diseased"))/length(predict(rfTempComp,tempTestNull2[1:testsize,]));
			SpecificityArrayNull2[i,k] <- length(which(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),])=="Control"))/length(predict(rfTempComp,tempTestNull2[(testsize+1):nrow(tempTestNull2),]));	

			k <- k + 1;
		}	
		
		i <- i + 1;
	}
	colnames(featureProfile) <- colnames(tempTrain);
	#returnList <- list("featureProfile"=featureProfile,"AUC"=AUCArray,"Accuracy"=AccuracyArray);
	returnList <- list("AUCSameAge"=AUCArraySelf,"SensitivitySameAge"=SensitivityArraySelf,"SpecificitySameAge"=SpecificityArraySelf,"AUCDiffAge"=AUCArrayNonSelf,"SensitivityDiffAge"=SensitivityArrayNonSelf,"SpecificityDiffAge"=SpecificityArrayNonSelf,"AUCNull1"=AUCArrayNull1,"SensitivityNull1"=SensitivityArrayNull1,"SpecificityNull1"=SpecificityArrayNull1,"AUCNull2"=AUCArrayNull2,"SensitivityNull2"=SensitivityArrayNull2,"SpecificityNull2"=SpecificityArrayNull2,"featureProfile"=featureProfile);
	return(returnList);
		
}

