print("Select Markers")
CirrhosisSelectMarkers <- unique(c(CirrhosisYoungTop85New,CirrhosisMiddleTop85New,CirrhosisElderlyTop85New))
IBDSelectMarkers <- unique(c(IBDYoungTop85New,IBDMiddleTop85New,IBDElderlyTop85New))
T2DSelectMarkers <- unique(c(T2DYoungTop85New,T2DMiddleTop85New,T2DElderlyTop85New))
CRCSelectMarkers <- unique(c(CRCYoungMiddleTop85New,CRCElderlyTop85New))
AdenomaSelectMarkers <- unique(c(AdenomaYoungMiddleTop85New,AdenomaElderlyTop85New))

print("Differential Markers for Cirrhosis")
CirrhosisAllAgeGroupsFeatureProfile <- rbind(rfCirrhosisPermutedMultipleNullYoung$featureProfile,rfCirrhosisPermutedMultipleNullMiddle$featureProfile,rfCirrhosisPermutedMultipleNullElderly$featureProfile)
CirrhosisAllAgeGroupsRawFeatureProfile <- CirrhosisAllAgeGroupsFeatureProfile
CirrhosisAllAgeGroupsFeatureProfile <- t(apply(CirrhosisAllAgeGroupsFeatureProfile,1,rank_scale))
CirrhosisAllAgeGroupsFeatureProfile1 <- t(apply(CirrhosisAllAgeGroupsFeatureProfile,1,range_scale))
CirrhosisMeanRawMarkerScores <- cbind(colMeans(CirrhosisAllAgeGroupsRawFeatureProfile[1:100,]),colMeans(CirrhosisAllAgeGroupsRawFeatureProfile[101:200,]),colMeans(CirrhosisAllAgeGroupsRawFeatureProfile[201:300,]))
CirrhosisMeanRankedMarkerScores <- cbind(colMeans(CirrhosisAllAgeGroupsFeatureProfile[1:100,]),colMeans(CirrhosisAllAgeGroupsFeatureProfile[101:200,]),colMeans(CirrhosisAllAgeGroupsFeatureProfile[201:300,]))
CirrhosisMeanRankedMarkerScores1 <- cbind(colMeans(CirrhosisAllAgeGroupsFeatureProfile1[1:100,]),colMeans(CirrhosisAllAgeGroupsFeatureProfile1[101:200,]),colMeans(CirrhosisAllAgeGroupsFeatureProfile1[201:300,]))
CirrhosisAllAgeGroupsDunns <- batch_dunns(CirrhosisAllAgeGroupsRawFeatureProfile[,CirrhosisSelectMarkers],as.factor(c(rep("Young",100),rep("Middle",100),rep("Elderly",100))))
CirrhosisAllAgeGroupsFeatureComp <- cbind(CirrhosisMeanRawMarkerScores[CirrhosisSelectMarkers,],CirrhosisAllAgeGroupsDunns$kruskal_p,CirrhosisAllAgeGroupsDunns$CorrectedP)
CirrhosisAllAgeGroupsFeatureComp <- as.data.frame(CirrhosisAllAgeGroupsFeatureComp)
CirrhosisAllAgeGroupsFeatureComp$Young_Feature <- ifelse(rownames(CirrhosisAllAgeGroupsFeatureComp) %in% CirrhosisYoungTop85New,1,0)
CirrhosisAllAgeGroupsFeatureComp$Middle_Feature <- ifelse(rownames(CirrhosisAllAgeGroupsFeatureComp) %in% CirrhosisMiddleTop85New,1,0)
CirrhosisAllAgeGroupsFeatureComp$Elderly_Feature <- ifelse(rownames(CirrhosisAllAgeGroupsFeatureComp) %in% CirrhosisElderlyTop85New,1,0)

print("Differential Markers for T2D")
T2DAllAgeGroupsFeatureProfile <- rbind(rfT2DPermutedMultipleNullYoung$featureProfile,rfT2DPermutedMultipleNullMiddle$featureProfile,rfT2DPermutedMultipleNullElderly$featureProfile)
T2DAllAgeGroupsRawFeatureProfile <- T2DAllAgeGroupsFeatureProfile
T2DAllAgeGroupsFeatureProfile <- t(apply(T2DAllAgeGroupsFeatureProfile,1,rank_scale))
T2DAllAgeGroupsFeatureProfile1 <- t(apply(T2DAllAgeGroupsFeatureProfile,1,range_scale))
T2DMeanRawMarkerScores <- cbind(colMeans(T2DAllAgeGroupsRawFeatureProfile[1:100,]),colMeans(T2DAllAgeGroupsRawFeatureProfile[101:200,]),colMeans(T2DAllAgeGroupsRawFeatureProfile[201:300,]))
T2DMeanRankedMarkerScores <- cbind(colMeans(T2DAllAgeGroupsFeatureProfile[1:100,]),colMeans(T2DAllAgeGroupsFeatureProfile[101:200,]),colMeans(T2DAllAgeGroupsFeatureProfile[201:300,]))
T2DMeanRankedMarkerScores1 <- cbind(colMeans(T2DAllAgeGroupsFeatureProfile1[1:100,]),colMeans(T2DAllAgeGroupsFeatureProfile1[101:200,]),colMeans(T2DAllAgeGroupsFeatureProfile1[201:300,]))
T2DAllAgeGroupsDunns <- batch_dunns(T2DAllAgeGroupsRawFeatureProfile[,T2DSelectMarkers],as.factor(c(rep("Young",100),rep("Middle",100),rep("Elderly",100))))
T2DAllAgeGroupsFeatureComp <- cbind(T2DMeanRawMarkerScores[T2DSelectMarkers,],T2DAllAgeGroupsDunns$kruskal_p,T2DAllAgeGroupsDunns$CorrectedP)
T2DAllAgeGroupsFeatureComp <- as.data.frame(T2DAllAgeGroupsFeatureComp)
T2DAllAgeGroupsFeatureComp$Young_Feature <- ifelse(rownames(T2DAllAgeGroupsFeatureComp) %in% T2DYoungTop85New,1,0)
T2DAllAgeGroupsFeatureComp$Middle_Feature <- ifelse(rownames(T2DAllAgeGroupsFeatureComp) %in% T2DMiddleTop85New,1,0)
T2DAllAgeGroupsFeatureComp$Elderly_Feature <- ifelse(rownames(T2DAllAgeGroupsFeatureComp) %in% T2DElderlyTop85New,1,0)

print("Differential Markers for IBD")
IBDAllAgeGroupsFeatureProfile <- rbind(rfIBDPermutedMultipleNullYoung$featureProfile,rfIBDPermutedMultipleNullMiddle$featureProfile,rfIBDPermutedMultipleNullElderly$featureProfile)
IBDAllAgeGroupsRawFeatureProfile <- IBDAllAgeGroupsFeatureProfile
IBDAllAgeGroupsFeatureProfile <- t(apply(IBDAllAgeGroupsFeatureProfile,1,rank_scale))
IBDAllAgeGroupsFeatureProfile1 <- t(apply(IBDAllAgeGroupsFeatureProfile,1,range_scale))
IBDMeanRawMarkerScores <- cbind(colMeans(IBDAllAgeGroupsRawFeatureProfile[1:100,]),colMeans(IBDAllAgeGroupsRawFeatureProfile[101:200,]),colMeans(IBDAllAgeGroupsRawFeatureProfile[201:300,]))
IBDMeanRankedMarkerScores <- cbind(colMeans(IBDAllAgeGroupsFeatureProfile[1:100,]),colMeans(IBDAllAgeGroupsFeatureProfile[101:200,]),colMeans(IBDAllAgeGroupsFeatureProfile[201:300,]))
IBDMeanRankedMarkerScores1 <- cbind(colMeans(IBDAllAgeGroupsFeatureProfile1[1:100,]),colMeans(IBDAllAgeGroupsFeatureProfile1[101:200,]),colMeans(IBDAllAgeGroupsFeatureProfile1[201:300,]))
IBDAllAgeGroupsDunns <- batch_dunns(IBDAllAgeGroupsRawFeatureProfile[,IBDSelectMarkers],as.factor(c(rep("Young",100),rep("Middle",100),rep("Elderly",100))))
IBDAllAgeGroupsFeatureComp <- cbind(IBDMeanRawMarkerScores[IBDSelectMarkers,],IBDAllAgeGroupsDunns$kruskal_p,IBDAllAgeGroupsDunns$CorrectedP)
IBDAllAgeGroupsFeatureComp <- as.data.frame(IBDAllAgeGroupsFeatureComp)
IBDAllAgeGroupsFeatureComp$Young_Feature <- ifelse(rownames(IBDAllAgeGroupsFeatureComp) %in% IBDYoungTop85New,1,0)
IBDAllAgeGroupsFeatureComp$Middle_Feature <- ifelse(rownames(IBDAllAgeGroupsFeatureComp) %in% IBDMiddleTop85New,1,0)
IBDAllAgeGroupsFeatureComp$Elderly_Feature <- ifelse(rownames(IBDAllAgeGroupsFeatureComp) %in% IBDElderlyTop85New,1,0)


print("Differential Markers for CRC")
CRCAllAgeGroupsFeatureProfile <- rbind(rfCRCPermutedMultipleNullYoungMiddle$featureProfile,rfCRCPermutedMultipleNullElderly$featureProfile)
CRCAllAgeGroupsRawFeatureProfile <- CRCAllAgeGroupsFeatureProfile
CRCAllAgeGroupsFeatureProfile <- t(apply(CRCAllAgeGroupsFeatureProfile,1,rank_scale))
CRCAllAgeGroupsFeatureProfile1 <- t(apply(CRCAllAgeGroupsFeatureProfile,1,range_scale))
CRCMeanRawMarkerScores <- cbind(colMeans(CRCAllAgeGroupsRawFeatureProfile[1:100,]),colMeans(CRCAllAgeGroupsRawFeatureProfile[101:200,]))
CRCMeanRankedMarkerScores <- cbind(colMeans(CRCAllAgeGroupsFeatureProfile[1:100,]),colMeans(CRCAllAgeGroupsFeatureProfile[101:200,]))
CRCMeanRankedMarkerScores1 <- cbind(colMeans(CRCAllAgeGroupsFeatureProfile1[1:100,]),colMeans(CRCAllAgeGroupsFeatureProfile1[101:200,]))
CRCAllAgeGroupsWilcox <- wilcox_batch(t(CRCAllAgeGroupsRawFeatureProfile[1:100,CRCSelectMarkers]),t(CRCAllAgeGroupsRawFeatureProfile[101:200,CRCSelectMarkers]))
CRCAllAgeGroupsFeatureComp <- cbind(CRCMeanRawMarkerScores[intersect(rownames(CRCMeanRawMarkerScores),rownames(CRCAllAgeGroupsWilcox)),],CRCAllAgeGroupsWilcox[intersect(rownames(CRCMeanRawMarkerScores),rownames(CRCAllAgeGroupsWilcox)),3])
CRCAllAgeGroupsFeatureComp <- as.data.frame(CRCAllAgeGroupsFeatureComp)
CRCAllAgeGroupsFeatureComp$YoungMiddle_Feature <- ifelse(rownames(CRCAllAgeGroupsFeatureComp) %in% CRCYoungMiddleTop85New,1,0)
CRCAllAgeGroupsFeatureComp$Elderly_Feature <- ifelse(rownames(CRCAllAgeGroupsFeatureComp) %in% CRCElderlyTop85New,1,0)


print("Differential Markers for Polyps")
AdenomaAllAgeGroupsFeatureProfile <- rbind(rfAdenomaPermutedMultipleNullYoungMiddle$featureProfile,rfAdenomaPermutedMultipleNullElderly$featureProfile)
AdenomaAllAgeGroupsRawFeatureProfile <- AdenomaAllAgeGroupsFeatureProfile
AdenomaAllAgeGroupsFeatureProfile <- t(apply(AdenomaAllAgeGroupsFeatureProfile,1,rank_scale))
AdenomaAllAgeGroupsFeatureProfile1 <- t(apply(AdenomaAllAgeGroupsFeatureProfile,1,range_scale))
AdenomaMeanRawMarkerScores <- cbind(colMeans(AdenomaAllAgeGroupsRawFeatureProfile[1:100,]),colMeans(AdenomaAllAgeGroupsRawFeatureProfile[101:200,]))
AdenomaMeanRankedMarkerScores <- cbind(colMeans(AdenomaAllAgeGroupsFeatureProfile[1:100,]),colMeans(AdenomaAllAgeGroupsFeatureProfile[101:200,]))
AdenomaMeanRankedMarkerScores1 <- cbind(colMeans(AdenomaAllAgeGroupsFeatureProfile1[1:100,]),colMeans(AdenomaAllAgeGroupsFeatureProfile1[101:200,]))
AdenomaAllAgeGroupsWilcox <- wilcox_batch(t(AdenomaAllAgeGroupsRawFeatureProfile[1:100,AdenomaSelectMarkers]),t(AdenomaAllAgeGroupsRawFeatureProfile[101:200,AdenomaSelectMarkers]))
AdenomaAllAgeGroupsFeatureComp <- cbind(AdenomaMeanRawMarkerScores[intersect(rownames(AdenomaMeanRawMarkerScores),rownames(AdenomaAllAgeGroupsWilcox)),],AdenomaAllAgeGroupsWilcox[intersect(rownames(AdenomaMeanRawMarkerScores),rownames(AdenomaAllAgeGroupsWilcox)),3])
AdenomaAllAgeGroupsFeatureComp <- as.data.frame(AdenomaAllAgeGroupsFeatureComp)
AdenomaAllAgeGroupsFeatureComp$YoungMiddle_Feature <- ifelse(rownames(AdenomaAllAgeGroupsFeatureComp) %in% AdenomaYoungMiddleTop85New,1,0)
AdenomaAllAgeGroupsFeatureComp$Elderly_Feature <- ifelse(rownames(AdenomaAllAgeGroupsFeatureComp) %in% AdenomaElderlyTop85New,1,0)












