% OS: Windows 10
% Matlab version: R2015a
% By Kai Xie @ City University of Hong Kong
% EXP DATA file is Exp_data_VTA_MFB.csv
% TRANSFER DATA file is Exp_data_VTA_MFB_Transfer.csv
% Sample output file is Exp_data_VTA_MFB_calibrated_to_vgeff.xlsx

clear all;

close all;

[exp_name,folder] = uigetfile('*.csv','Select the EXP DATA file');
[transfer_name,folder_transfer] = uigetfile('*.csv','Select the TRANSFER DATA file');

display(exp_name);
display(transfer_name);

starting_pos = 1247;
data_length = 1846 - starting_pos;

read_exp_addr = strcat(folder,exp_name);
read_transfer_addr = strcat(folder,transfer_name);

write_result_addr = strcat(folder,exp_name(1:length(exp_name)-4),'_calibrated_to_vgeff.xlsx');

exp_raw = xlsread(read_exp_addr);
cycle = exp_raw(42,2);
time = linspace(0,29.95,600)';
result = time;

for n = 1:cycle-1
    data_pos = starting_pos + (n-1)*1000;
    temp = exp_raw(data_pos : data_pos + data_length, 7);
    result = [result,temp];
end

transfer_raw = xlsread(read_transfer_addr);
transfer(:,1) = transfer_raw(47:46+transfer_raw(42,2),3);
transfer(:,2) = transfer_raw(47:46+transfer_raw(42,2),7);
p = fit(transfer(:,2), transfer(:,1),'pchipinterp');
fit_vgeff = feval(p, linspace(min(transfer(:,2)),max(transfer(:,2)),10000));
plot(linspace(min(transfer(:,2)),max(transfer(:,2)),10000),fit_vgeff,'r');
hold on
plot(transfer(:,2), transfer(:,1),'g');
xlabel('Isd(A)');
ylabel('Vsg(V)');
hold off

figure
plot(result(1:600,1),result(1:600,6));
isd_begin = input('Input the time indicating the the baseline before stimulation (i.e., 16.25): ');
isd_end_longer = input('Input the time 0.5 second after the time of peak responds (i.e., 18.00): ');
close

result_vgeff = time;
for n = 1:cycle-1
    temp_fit_vgeff = feval(p,result(1:600,n+1));
    isd_begin_plot = isd_begin;
    isd_end_plot = isd_end_longer;
    id = 1;
    while 1
        switch(id)
        case 1
            figure
            plot(result(1:600,1), temp_fit_vgeff,'g');
            title(['Sweep ' num2str(n)]);
            hold on
            plot(linspace(isd_begin_plot,isd_begin_plot, 5),linspace(max(temp_fit_vgeff), min(temp_fit_vgeff),5),'r');
			[x, y] =  min(result(isd_begin_plot * 20 + 1 : isd_end_plot * 20 + 1, n+1)');
			isd_end_plot = isd_begin_plot + (y-1)/20;
            plot(linspace(isd_end_plot,isd_end_plot, 5),linspace(max(temp_fit_vgeff), min(temp_fit_vgeff),5),'b');
            hold off
            check = input('Press Enter to continue and save the result.');
            close
            id = 2;
        case 2
            if n == 1
                result_time_begin = isd_begin_plot;
                result_time_end = isd_end_plot;
                result_delta_vgeff = feval(p, result(int64(isd_end_plot*20+1),n+1)) - feval(p,result(int64(isd_begin_plot*20+1),n+1));
            else
                result_time_begin = [result_time_begin, isd_begin_plot];
                result_time_end = [result_time_end, isd_end_plot];
                result_delta_vgeff = [result_delta_vgeff, (feval(p, result(int64(isd_end_plot*20+1),n+1)) - feval(p,result(int64(isd_begin_plot*20+1),n+1)))];
            end
            display(['delta Vg-eff = ', num2str((feval(p, result(int64(isd_end_plot*20+1),n+1)) - feval(p,result(int64(isd_begin_plot*20+1),n+1))))]);
            result_vgeff = [result_vgeff, temp_fit_vgeff];
            break; 
        end
    end
end

write_result = num2cell(result);

write_result_vgeff = num2cell(result_vgeff);


write_result_time_begin = num2cell(result_time_begin);
write_result_time_begin = [{'Begin time(s)'}, write_result_time_begin];

write_result_time_end = num2cell(result_time_end);
write_result_time_end = [{'End time(s)'}, write_result_time_end];

write_statistics(1,1) = {'Sweep No.'};
write_statistics(1,2) = num2cell(cycle-1);
write_statistics(1,3) = {'Average Vgeff(V)'};
write_statistics(1,4) = num2cell(mean(result_delta_vgeff));
write_statistics(1,5) = {'STD Vgeff(V)'};
write_statistics(1,6) = num2cell(std(result_delta_vgeff));
for m = 7:cycle
    write_statistics(1,m) = {' '};
end

write_result_delta_vgeff = num2cell(result_delta_vgeff);
write_result_delta_vgeff = [{'Delta Vgeff(V)'}, write_result_delta_vgeff];

column_header(1,1) = {'Sweep No.'};
column_isd(1,1) = {'Time(s)'};
column_vgeff(1,1) = {'Time(s)'};
for n = 1:cycle-1
    column_header(1,n+1) = {n};
    column_isd(1,n+1) = {'Isd(A)'};
    column_vgeff(1,n+1) = {'Vgeff(V)'};
end

write = [
    write_statistics;
    column_header;
    write_result_time_begin;
    write_result_time_end;
    write_result_delta_vgeff;
    column_isd;
    write_result;
    column_vgeff;
    write_result_vgeff
    ];

close all;

xlswrite(write_result_addr,write);