#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Apr  8 19:29:18 2019

@author: cherri
"""

import matplotlib.pyplot as plt
import numpy as np
datadir='data/'
graphdir='graphs/'
#experiments 1 DFu (area) = 5.62um ^2 
plt.rcParams.update({'font.size': 18, 'font.sans-serif': 'Arial', 'font.family':"sans-serif"})


R95wt=np.load(datadir+'R95-wildtype.npy')
R95tm2=np.load(datadir+'R95-Tm2.npy')
R95tm9=np.load(datadir+'R95-Tm9.npy')
R95babo=np.load(datadir+'R95-babo.npy')
R95early=np.load(datadir+'R95-early.npy')
R95big001=np.load(datadir+'R95-big001-360.npy')
R95big002=np.load(datadir+'R95-big002-360.npy')
R95big005=np.load(datadir+'R95-big005-360.npy')
R95big0005=np.load(datadir+'R95-big0005-360.npy')
R95bigtwo1=np.load(datadir+'R95-big2stage_kfinc.npy')
R95bigtwo=np.load(datadir+'R95-big2stage.npy')
plotobj, ax1 = plt.subplots()
plt.boxplot([R95wt,R95babo,R95tm2, R95tm9, R95big001,R95big002,R95big005, R95bigtwo,R95bigtwo1],labels=['Tm20','$\mathit{babo}$','Tm2','Tm9',  r'$\Delta k=0.001$', r'$\Delta k=0.002$',r'$\Delta k=0.005$','Two-stage',r'Two-stage-$k_f$ inc'])
plt.ylabel("Neuron Radius ($\mu$m)")
plt.xticks(rotation=50)
ax2 = ax1.twinx()  # instantiate a second axes that shares the same x-axis
ax2.yaxis.set_label_position("right")
ax2.set_ylim([ax1.set_ylim()[0], ax1.set_ylim()[1]])
ax2.set_yticks((0,10.03,20.05,30.08,40.11,50.13)) # or is 1 dfu = 5.62^2 um^2?
ax2.set_yticklabels(('0','10','40','90','160','250'))

ax2.set_ylabel('Dfu')
plotobj.savefig(graphdir+"boxplot.pdf",bbox_inches='tight')
ax1.set_ylim(0,25)
ax2.set_ylim(0,25)
plotobj.savefig(graphdir+"boxplotzoom.pdf",bbox_inches='tight')

