#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Apr  4 16:04:18 2019

@author: cherri
"""


import numpy as np
#import random as rand
import matplotlib.pyplot as plt
from matplotlib.patches import Rectangle

#import scipy.ndimage
datadir='data/'
graphdir='graphs/'

#plt.style.use('seaborn-white')
plt.rcParams.update({'font.size': 18, 'font.sans-serif': 'Arial', 'font.family':"sans-serif"})



#####################################3
collect_kb=np.load(datadir+'collect_kb.npy')
collect_kt=np.load(datadir+'collect_kt.npy')
collect_rterm_mean=np.load(datadir+'collect_rterm_mean.npy')
collect_rterm_std=np.load(datadir+'collect_rterm_std.npy')
collect_R95_mean=np.load(datadir+'collect_R95_mean.npy')
collect_R95_std=np.load(datadir+'collect_R95_std.npy')
collect_densityR95_mean=np.load(datadir+'collect_densityR95_mean.npy')
collect_densityR95_std=np.load(datadir+'collect_densityR95_std.npy')



#####################################3


fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, collect_R95_mean ,cmap='rainbow') #, levels=levels)
ax.set_xlabel('Terminating frequency')
ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
plt.colorbar(cs)
plt.plot(0.594,0.360,'w*') 
plt.plot(0.431,0.322,'w^') # Tm20 in babo mutant terminating rate from Ting2014

ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
fig.savefig(graphdir+"R95_meanv2.pdf",bbox_inches='tight')
ax.add_patch(plt.Rectangle((.358, .355), .01, .01, ec="k", fc="None", transform=ax.transAxes))
ax.add_patch(plt.Rectangle((.011, .010), .08, .08, ec="k", fc="None", transform=ax.transAxes))
plt.arrow(0.364, 0.53, 0, -0.06, head_width=0.04, linewidth=2, color='k')
axin = plt.axes([.3, .6, .25, .25])
axin.set_xlim(0.358, 0.368)
axin.set_ylim(0.355, 0.365)
axin.tick_params(axis='both', which='major', labelsize=13)

axin.tricontourf(collect_kt, collect_kb, collect_R95_mean ,cmap='rainbow') #, 
axin.set_aspect('equal')
axin.plot(0.361,0.360,'k.') 
axin.plot(0.362,0.360,'k.') 
axin.plot(0.365,0.360,'k.') 
plt.show()
fig.savefig(graphdir+"R95_meanv2_zoom.pdf",bbox_inches='tight')


### std

fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, collect_R95_std ,cmap='rainbow') #, levels=levels)
ax.set_xlabel('Terminating frequency')
ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
plt.colorbar(cs)
plt.plot(0.594,0.360,'w*') 
plt.plot(0.431,0.322,'w^') # Tm20 in babo mutant terminating rate from Ting2014
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
fig.savefig(graphdir+"R95_stdv2.pdf",bbox_inches='tight')

ax.add_patch(plt.Rectangle((.358, .355), .01, .01, ec="k", fc="None", transform=ax.transAxes))
ax.add_patch(plt.Rectangle((.011, .010), .08, .08, ec="k", fc="None", transform=ax.transAxes))
plt.arrow(0.364, 0.53, 0, -0.06, head_width=0.04, linewidth=2, color='k')
axin = plt.axes([.3, .6, .25, .25])
axin.set_xlim(0.358, 0.368)
axin.set_ylim(0.355, 0.365)
axin.tick_params(axis='both', which='major', labelsize=13)

axin.tricontourf(collect_kt, collect_kb, collect_R95_std ,cmap='rainbow') #, 
axin.set_aspect('equal')
axin.plot(0.361,0.360,'k.') 
axin.plot(0.362,0.360,'k.') 
axin.plot(0.365,0.360,'k.') 

#ax.indicate_inset_zoom(axins)
plt.show()
fig.savefig(graphdir+"R95_stdv2_zoom.pdf",bbox_inches='tight')


ratio=collect_R95_std/collect_R95_mean
fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, ratio ,cmap='rainbow') #, levels=levels)
ax.set_xlabel('Terminating frequency')
ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
plt.colorbar(cs)
plt.plot(0.594,0.360,'w*') 
plt.plot(0.431,0.322,'w^') # Tm20 in babo mutant terminating rate from Ting2014
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
fig.savefig(graphdir+"R95_std_to_meanv2.pdf",bbox_inches='tight')

ax.add_patch(plt.Rectangle((.358, .355), .01, .01, ec="k", fc="None", transform=ax.transAxes))
ax.add_patch(plt.Rectangle((.011, .010), .08, .08, ec="k", fc="None", transform=ax.transAxes))
plt.arrow(0.364, 0.53, 0, -0.06, head_width=0.04, linewidth=2, color='k')
axin = plt.axes([.3, .6, .25, .25])
axin.set_xlim(0.358, 0.368)
axin.set_ylim(0.355, 0.365)
axin.tick_params(axis='both', which='major', labelsize=13)

axin.tricontourf(collect_kt, collect_kb, ratio ,cmap='rainbow') #, 
axin.set_aspect('equal')
axin.plot(0.361,0.360,'k.') 
axin.plot(0.362,0.360,'k.') 
axin.plot(0.365,0.360,'k.') 

plt.show()
fig.savefig(graphdir+"R95_std_to_meanv2_zoom.pdf",bbox_inches='tight')


### density

fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
levels=[0,1,2,3,4,8,12,16,20,24,28,32]
cs=ax.tricontourf(collect_kt, collect_kb, collect_densityR95_mean,cmap='rainbow')#, levels=levels)
ax.set_xlabel('Terminating frequency')
ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
plt.colorbar(cs)
plt.plot(0.594,0.360,'w*') 
plt.plot(0.431,0.322,'w^') # Tm20 in babo mutant terminating rate from Ting2014
ax.set_xlim(0, 1)
ax.set_ylim(0, 1)
fig.savefig(graphdir+"densityR95v2.pdf",bbox_inches='tight')

ax.add_patch(plt.Rectangle((.358, .355), .01, .01, ec="k", fc="None", transform=ax.transAxes))
ax.add_patch(plt.Rectangle((.011, .010), .08, .08, ec="k", fc="None", transform=ax.transAxes))
plt.arrow(0.364, 0.53, 0, -0.06, head_width=0.04, linewidth=2, color='k')
axin = plt.axes([.3, .6, .25, .25])
axin.set_xlim(0.358, 0.368)
axin.set_ylim(0.355, 0.365)
axin.tick_params(axis='both', which='major', labelsize=13)

axin.tricontourf(collect_kt, collect_kb, collect_densityR95_mean ,cmap='rainbow') #, 
axin.set_aspect('equal')
axin.plot(0.361,0.360,'k.') 
axin.plot(0.362,0.360,'k.') 
axin.plot(0.365,0.360,'k.') 

#ax.indicate_inset_zoom(axins)
plt.show()
fig.savefig(graphdir+"densityR95v2_zoom.pdf",bbox_inches='tight')


plt.rcParams.update({'font.size': 36, 'font.sans-serif': 'Arial', 'font.family':"sans-serif"})


fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, collect_R95_mean,cmap='rainbow')#, levels=levels)
#ax.set_xlabel('Terminating frequency')
#ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
#plt.colorbar(cs)
ax.set_xlim(0.011, 0.109)
ax.set_ylim(0.010, 0.108)
fig.savefig(graphdir+"R95meanzoom010.pdf",bbox_inches='tight')

fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, collect_R95_std,cmap='rainbow')#, levels=levels)
#ax.set_xlabel('Terminating frequency')
#ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
#plt.colorbar(cs)
ax.set_xlim(0.011, 0.109)
ax.set_ylim(0.010, 0.108)
fig.savefig(graphdir+"R95stdzoom010.pdf",bbox_inches='tight')

fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, ratio,cmap='rainbow')#, levels=levels)
#ax.set_xlabel('Terminating frequency')
#ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
#plt.colorbar(cs)
ax.set_xlim(0.011, 0.109)
ax.set_ylim(0.010, 0.108)
fig.savefig(graphdir+"R95CVzoom010.pdf",bbox_inches='tight')



fig=plt.figure()
#ax=plt.figure()
ax = fig.add_subplot(111)
cs=ax.tricontourf(collect_kt, collect_kb, collect_densityR95_mean,cmap='rainbow')#, levels=levels)
#ax.set_xlabel('Terminating frequency')
#ax.set_ylabel('Branching frequency')
ax.set_aspect('equal')
#plt.colorbar(cs)
ax.set_xlim(0.011, 0.109)
ax.set_ylim(0.010, 0.108)
fig.savefig(graphdir+"densityR95zoom010.pdf",bbox_inches='tight')

#plt.show()
#plotobj.savefig(graphdir+"R95_meanv2.pdf",bbox_inches='tight')







