#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Apr  3 12:16:40 2019

@author: cherri
"""
import numpy as np
import random as rand


class Neuron:
    "this is a class for one neuron randomly growing"
    def __init__(self,n0):
        self.n0=n0
        
    def statistics(self):
        self.dendritelength=self.startend[:,1]-self.startend[:,0]
        self.totallength=np.sum(self.dendritelength)
        self.R_terminating=self.r_terminating**0.5
        self.R95=np.percentile(self.r_terminating**0.5,95)
        self.Rg=np.sqrt(np.sum(self.n_traj/2*(np.append(np.diff(self.r_traj**2),0))/self.totallength))
        self.densityR95=self.totallength/np.pi/self.R95**2
        self.densityRg=self.totallength/np.pi/self.Rg**2
        return

class Neuron_one(Neuron):
    type='one-stage growing neoron'
    
    def nrtraj(self,kb,kt):
        diffk=kb-kt
        rmax=1/abs(diffk)*10
        r=0.
        n=self.n0
        self.n_traj=np.array([n])
        self.r_traj=np.array([r])
        self.dr=np.zeros(0) #[0]
        self.r_terminating=np.zeros(0) #[]
        #n_terminating=0
        n0=self.n0
        self.startend=np.zeros((n0,2)) #keep the starting and ending r for each dendrite
        self.startend_b=np.zeros((0,2))
        self.startend_t=np.zeros((0,2))
        surviving=np.arange(n0)
        nindexing=n0
        while n>0 and r<rmax:
            prop=[n*kb, n*kt]
            a=sum(prop)
            deltar=-1./a*np.log(rand.random())
            r=r+deltar
            self.dr=np.append(self.dr,deltar)#dr.append(deltar)
            if rand.random()<prop[0]/a:
                i_branch=rand.randrange(n)
                n=n+1 # branching event
                nindexing+=2
                branch=surviving[i_branch]
                surviving=np.delete(surviving,i_branch)
                self.startend[branch,1]=r
                self.startend_b=np.append(self.startend_b, [self.startend[branch]],axis=0)
                self.startend=np.append(self.startend,[[r,0]],axis=0)
                self.startend=np.append(self.startend,[[r,0]],axis=0)
                surviving=np.append(surviving, [nindexing-2, nindexing-1])
            else:
                i_term=rand.randrange(n) #index of the terminating dendrite
                n=n-1 # terminating event
                self.r_terminating=np.append(self.r_terminating,r)#r_terminating.append(r)
                term=surviving[i_term]
                surviving=np.delete(surviving,i_term)
                self.startend[term,1]=r
                self.startend_t=np.append(self.startend_t, [self.startend[term]],axis=0)
                    #n_terminating+=1
#            if n!=0:
            self.n_traj=np.append(self.n_traj,n)
            self.r_traj=np.append(self.r_traj,r)
        #end while loop here
        return
     

   
class Neuron_two(Neuron):
    type='two-stage growing neoron'
    
    def nrtraj(self,kb_in,kt_in,tarray):
        t=tarray[0] # t_switch is only 1 number here.  use array for easier programming in the main program stochastic.py
        diffk=kb_in[-1]-kt_in[-1]
        rmax=1/abs(diffk)*10+t
        r=0.
        n=self.n0
        self.n_traj=np.array([n])
        self.r_traj=np.array([r])
        self.dr=np.zeros(0) #[0]
        self.r_terminating=np.zeros(0) #[]
        #n_terminating=0
        n0=self.n0
        self.startend=np.zeros((n0,2)) #keep the starting and ending r for each dendrite
        self.startend_b=np.zeros((0,2))
        self.startend_t=np.zeros((0,2))
        surviving=np.arange(n0)
        nindexing=n0
        while n>0 and r<rmax:
            if r<t:
                kb=kb_in[0]
                kt=kt_in[0]
            else:
                kb=kb_in[1]
                kt=kt_in[1]
                
            prop=[n*kb, n*kt]
            a=sum(prop)
            deltar=-1./a*np.log(rand.random())
            r=r+deltar
            self.dr=np.append(self.dr,deltar)#dr.append(deltar)
            if rand.random()<prop[0]/a:
                i_branch=rand.randrange(n)
                n=n+1 # branching event
                nindexing+=2
                branch=surviving[i_branch]
                surviving=np.delete(surviving,i_branch)
                self.startend[branch,1]=r
                self.startend_b=np.append(self.startend_b, [self.startend[branch]],axis=0)
                self.startend=np.append(self.startend,[[r,0]],axis=0)
                self.startend=np.append(self.startend,[[r,0]],axis=0)
                surviving=np.append(surviving, [nindexing-2, nindexing-1])
            else:
                i_term=rand.randrange(n) #index of the terminating dendrite
                n=n-1 # terminating event
                self.r_terminating=np.append(self.r_terminating,r)#r_terminating.append(r)
                term=surviving[i_term]
                surviving=np.delete(surviving,i_term)
                self.startend[term,1]=r
                self.startend_t=np.append(self.startend_t, [self.startend[term]],axis=0)
                    #n_terminating+=1
#            if n!=0:
            self.n_traj=np.append(self.n_traj,n)
            self.r_traj=np.append(self.r_traj,r)
        #end while loop here
        return
     
 

        
        
            
            

        