#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Apr  3 15:31:29 2019

@author: cherri
"""

import numpy as np
#import random as rand
#import matplotlib.pyplot as plt
#import sys
#sys.path.append('/Users/cherri/Google\ Drive/dendrite/work_paper-032019')
#from neuronclass import Neuron
from neuronclass import *
datadir='data/'
graphdir='graphs/'

k0b=0.01
k0t=0.01
nscan=50
deltak=0.02
nsample=100

n0=30

rterm_mean_matrix=np.zeros((nscan,nscan))
rterm_std_matrix=np.zeros((nscan,nscan))
R95_mean_matrix=np.zeros((nscan,nscan))
R95_std_matrix=np.zeros((nscan,nscan))
densityR95_mean_matrix=np.zeros((nscan,nscan))
densityR95_std_matrix=np.zeros((nscan,nscan))

collect_kb=np.zeros(0);
collect_kt=np.zeros(0);
collect_rterm_mean=np.zeros(0);
collect_rterm_std=np.zeros(0);
collect_R95_mean=np.zeros(0);
collect_densityR95_mean=np.zeros(0);
collect_rterm_std=np.zeros(0);
collect_R95_std=np.zeros(0);
collect_densityR95_std=np.zeros(0);

for ib in range(nscan):
    kb=k0b+ib*deltak
    for it in range(ib+1,nscan):
        kt=k0t+it*deltak
#        filename="scan"+str(kb)+str(kt)
        print(f'kb {kb:.3f} kt {kt:.3f} starting')
        diffk=kb-kt
        sumk=kt+kb
        rmax=1/abs(diffk)*10

        R95=np.zeros(0)
        densityR95=np.zeros(0)
        rterm=np.zeros(0)
        for isample in range(nsample):
            neuron=Neuron_one(n0)
            neuron.nrtraj(kb,kt)
            neuron.statistics()
            R95=np.append(R95,neuron.R95)
            densityR95=np.append(densityR95,neuron.densityR95)
            rterm=np.append(rterm,neuron.r_terminating)
        #end isample
        
        rterm_mean_matrix[ib,it]=np.mean(rterm)
        rterm_std_matrix[ib,it]=np.std(rterm)
        R95_mean_matrix[ib,it]=np.mean(R95)
        R95_std_matrix[ib,it]=np.std(R95)
        densityR95_mean_matrix[ib,it]=np.mean(densityR95)
        densityR95_std_matrix[ib,it]=np.std(densityR95)
        
        collect_kb=np.append(collect_kb,kb);
        collect_kt=np.append(collect_kt,kt);
        collect_rterm_mean=np.append(collect_rterm_mean,np.mean(rterm));
        collect_rterm_std=np.append(collect_rterm_std,np.std(rterm));
        collect_R95_mean=np.append(collect_R95_mean,np.mean(R95));
        collect_R95_std=np.append(collect_R95_std,np.std(R95));
        collect_densityR95_mean=np.append(collect_densityR95_mean,np.mean(densityR95));
        collect_densityR95_std=np.append(collect_densityR95_std,np.std(densityR95));

        print(f'kb {kb:.3f} kt {kt:.3f} finished')
        
#end ib it loops

        
np.save(datadir+'rterm_mean_2d', rterm_mean_matrix)
np.save(datadir+'rterm_std', rterm_std_matrix)
np.save(datadir+'R95_mean', R95_mean_matrix)
np.save(datadir+'R95_std', R95_std_matrix)
np.save(datadir+'densityR95_mean', densityR95_mean_matrix)
np.save(datadir+'densityR95_std', densityR95_std_matrix)

#second scan loop
for ib in range(nscan):
    kb=k0b+ib*deltak
    for idiff in range(-5, 0,1):
        kt=kb+deltak*2**idiff
        
        R95=np.zeros(0)
        Rg=np.zeros(0)
        densityR95=np.zeros(0)
        densityRg=np.zeros(0)
        rterm=np.zeros(0)
        print(f'kb {kb:.4f} kt {kt:.4f} starting')
        for isample in range(nsample):
            neuron=Neuron_one(n0)
            neuron.nrtraj(kb,kt)
            neuron.statistics()
            R95=np.append(R95,neuron.R95)
            densityR95=np.append(densityR95,neuron.densityR95)
            rterm=np.append(rterm,neuron.r_terminating)
        #end isample
        
        collect_kb=np.append(collect_kb,kb);
        collect_kt=np.append(collect_kt,kt);
        collect_rterm_mean=np.append(collect_rterm_mean,np.mean(rterm));
        collect_rterm_std=np.append(collect_rterm_std,np.std(rterm));
        collect_R95_mean=np.append(collect_R95_mean,np.mean(R95));
        collect_R95_std=np.append(collect_R95_std,np.std(R95));
        collect_densityR95_mean=np.append(collect_densityR95_mean,np.mean(densityR95));
        collect_densityR95_std=np.append(collect_densityR95_std,np.std(densityR95));
        print(f'kb {kb:.4f} kt {kt:.4f} finished')

#end second scan loop

np.save(datadir+'collect_kb',collect_kb)
np.save(datadir+'collect_kt',collect_kt)
np.save(datadir+'collect_rterm_mean',collect_rterm_mean)
np.save(datadir+'collect_rterm_std',collect_rterm_std)
np.save(datadir+'collect_R95_mean',collect_R95_mean)
np.save(datadir+'collect_R95_std',collect_R95_std)
np.save(datadir+'collect_densityR95_mean',collect_densityR95_mean)
np.save(datadir+'collect_densityR95_std',collect_densityR95_std)


