function [IMG] = generatePosListfast_cells(fdir,currentf,fname)
Folder = [fdir currentf];
fdtosave = ['.' filesep 'Tracks' filesep fname];
mkdir(fdtosave)
expList = dir([Folder, filesep '*-*']);

%%
for expId = 1:length(expList)
    clearvars -except expId expList Folder refList fname fdir currentf fdtosave fitP
    disp(expId)
    Int = []; BG = [];
    xxs = []; yys = [];
    
    name01 = [Folder, '/', expList(expId).name, '/Pos0/'];
    refimgMreB = [strrep(name01,'Pos0/',''),'AVG_Pos1.tif'];
    refimgMreB = strrep(refimgMreB,'/',filesep);
    refimgMreB = strrep(refimgMreB,'\',filesep);
    IMG = double(imread(refimgMreB));
    load([Folder, filesep, expList(expId).name,filesep,'mask'], 'BW','cells', 'refimg') 
    nbCells = size(cells, 1);
    BW = BW(1:512, 1:512);
    
    fileList = dir([name01,'img*.tif']);
    name = {fileList.name};

    i = 2;
    penalty = 0;
    somme = zeros(size(IMG));
    test = 0;
    pZ = 0;
    PosList = zeros(500000,3);
    fitP = zeros(500000,4);
    peak_details = zeros(500000,6);
    center_int = zeros(500000,1);
    l = 0;
    while i < length(fileList)-1
        i = i+1;

        img = zeros(size(IMG));
        clear imgfilter beadPos mask a b res img_vec imgfilter_vec xout mx diff Peaks Peaksz out
        img = double(imread([name01,name{i}]));
        img_vec = reshape(img,[],1);
        somme = somme + img;
        
        peakFinding;
        size(xout, 1),
        if (not(isempty(xout)))
            pZ = pZ + 1; 
            penalty = 0;
            
            k = length(xout(:,1));
            l = l + k;

            PosList(l-k+1:l,1) = xout(:,5);
            PosList(l-k+1:l,2) = xout(:,6);
            PosList(l-k+1:l,3) = i;% str2num(name{i}(5:13));

            % peak_details : col 1 = img30per, 2 = raw img BG, 3 = mx_local_BG_std
            % 4 = global filter noise, 5 = raw peak intensity, 6 = filter peak intensity
            
            peak_details(l-k+1:l, 1) = out(:, 4);
            peak_details(l-k+1:l, 2) = out(:, 5);
            peak_details(l-k+1:l, 3) = out(:, 6);
            peak_details(l-k+1:l, 4) = out(:, 7);
            peak_details(l-k+1:l, 5) = out(:, 8);
            peak_details(l-k+1:l, 6) = out(:, 9);
            
            center_int(l-k+1:l, 1) = out(:, 10);
            
            fitP(l-k+1:l, 1) = xout(:,4);
            fitP(l-k+1:l, 2) = xout(:,7);
            fitP(l-k+1:l, 3) = xout(:,2);
            fitP(l-k+1:l, 4) = xout(:,1);
            
        else
            penalty = penalty + 1;
        end
        if test == 1
            name{i}
            figure(200+i),imagesc(imgfilter),axis equal,colormap(gray)
            if (not(isempty(xout)))
                hold on
                scatter(mx(:,2), mx(:,1), 'g', 'o') 
                scatter(xout(:,6), xout(:,5), 'r', 'x')
            end
            figure(1),imagesc(img),axis equal,colormap(gray), hold on
            scatter(mx(:,2), mx(:,1), 'g', 'o') 
            % NB : we must change the x and y pos because imagesc shows x in absciss and y in  ordinate
            scatter(xout(:,6), xout(:,5), 'r', 'x')
            out, xout
            length(out(:,1))
            pause
        end
    end
    
    PosList = PosList(fitP(:,4)>0,:);
    peak_details = peak_details(fitP(:,4)>0,:);
    center_int = center_int(fitP(:,4)>0,:);
    fitP = fitP(fitP(:,4)>0,:);
    
    n = [fdtosave filesep currentf '_' expList(expId).name '.mat'];
    save('/home/mcm/temp', 'PosList', 'refimg', 'cells', 'BW','refimgMreB', 'fitP', 'peak_details')
    movefile(['/home/mcm/temp.mat'], n)
end
