clear;close all;clc
fdir = ['/home/mcm/Desktop/Fiji.app/test/']; % note that directory name must be finished with a '/'
cd(fdir)

expList = dir('Tracks/*-*');

peaknbs = []; %array that contains the number of peaks considered for tracking detected per experiment

std_max = 3; % maximum peak width in pixels 
maxDisplacement = 4; %maximum allowed displacement in pixels
ImagingInterval = 60; % time [ms] in between conscutive images 
raw_th = 1.6; % threshold for local maxima to be considered as peaks (normalized by median intensity)
Res_max = 0.2; % threshold on the sum of residuals / fitted peak intensity 

PathC_name = strcat('Res', string(Res_max),'_Int', 'percentage', '_std', string(std_max), ...
'_MaxDisp',string(maxDisplacement), '_rawth', string(raw_th), '/'); %folder to store tracking results

for i = 1:length(expList)
    
    expName = expList(i).name;
    
    ToSave = 1;
    trackingInCells = 1;
    peaknbs = [peaknbs, sptFromPosList(fdir,expName,PathC_name,trackingInCells,...
        ImagingInterval, maxDisplacement, ToSave, Res_max, 'percentage', std_max,  raw_th, 4)];
    % paths contains x, y , frame, pathID
end
%%