function pathsNoTrafo = sptFromPosList(...
    fdir,fname,ImagingInterval,maxDisplacement,ToSave,dir_for_tracks)
%%
n = [fdir fname filesep];

load(dir_for_tracks)

AllDcent = []; Allsteps = []; Alllens = []; AlldistC = []; Allangles = [];
StorePaths = [];
NB = 0;
KO = []; pathsNoTrafo = [];
fast = 0; slow = 0;
AnzPfade = 0; simSpotsCell = []; DiffAll = []; SpotsPerCell = []; TracksPerCell = [];

try
    Int = zeros(length(PosList),4);

    TStep = ImagingInterval;
    dummyCell = [];
    for ceI = 1:length(cells)
        if not(isempty(cells(ceI).Area))
            dummyCell = [dummyCell; cells(ceI)];
        end
    end
    clear cells
    cells = dummyCell;
    
    str = [fdir refimgMreB];
    str = strrep(str,'/',filesep); 
    str = strrep(str,'\',filesep);
    if (exist(str, 'file') == 2)
        IMG = double(imread(str));
    else
        IMG = zeros([512, 512]);
    end
    
    if size(BW, 1) > 512 || size(BW, 2) > 512
        BW = BW(1:512, 1:512);
    end
    IMG = IMG ./ max(max(IMG(BW > 0)));
    figure(100),
    imagesc(BW),hold on,axis equal,colormap(gray)
    
    POSLIST = [];
    INTLIST = [];
    for j = 1:max(PosList(:,3))
        ind = find(PosList(:,3)==j);
        if isempty(ind)
            POSLIST = [POSLIST; 0 0 j 0];
            INTLIST = [INTLIST; 0 0 0 0 j 0];
        else
            %%
            for k = ind'
                cellNB = BW(round(PosList(k,2)), round(PosList(k,1)));
                if cellNB == 0
                    cellNB = BW(ceil(PosList(k,2)), ceil(PosList(k,1)));
                    if cellNB == 0
                        cellNB = BW(floor(PosList(k,2)), floor(PosList(k,1)));
                    end
                end
                if cellNB == 0
                    POSLIST = [POSLIST; 0 0 j 0];
                    INTLIST = [INTLIST; 0 0 0 0 j 0];
                else
                    POSLIST = [POSLIST; [PosList(k,1:3) cellNB]];
                    INTLIST = [INTLIST; [Int(k, :) PosList(k,3) cellNB]];
                end
            end
        end
    end
    PosList = POSLIST;
    IntList = INTLIST;
    
    PosListGem = [];
    for zeit = 1:max(POSLIST(:,3))
        subPosList = POSLIST(POSLIST(:,3)==zeit, :);
        zellen = unique(subPosList(:,4))';
        zellen = zellen(zellen > 0) ;
        if ~isempty(zellen)
            for k = zellen
                if (sum(subPosList(:,4) == k) > 1)
                    PosListGem = [PosListGem; subPosList(subPosList(:,4) == k,:)];
                end
            end
        end
    end
    if ~isempty(PosListGem)
        simSpotsCell = [];
        for j = unique(PosListGem(:,3))'
            subPosListGem = PosListGem(PosListGem(:,3) == j, :);
            for k = unique(subPosListGem(:,4))'
                simSpotsCell = [simSpotsCell; sum(subPosListGem(:,4) == k)];
            end
        end
    end
    
    zellen = unique(PosList(:,4))';
    zellen = zellen(zellen > 0) ;
    if ~isempty(zellen)
        for k = zellen
            SpotsPerCell = [SpotsPerCell; sum(PosList(:,4) == k)];
        end
    end
    
    idx = find(PosList(:,4) ~= 0);
    PosList = PosList(idx,:);
    IntList = IntList(idx,:);
    for iT = 1:floor(max(PosList(:,3))/10)*10/10+1
        TimeGrob = floor(PosList(:,3)/10)*10/10+1;
        idxTime = find(TimeGrob == iT);
        
    end
    alpha= cat(1, cells.Orientation);
    AxMin = cat(1, cells.MinorAxisLength);
    AxMaj = cat(1, cells.MajorAxisLength);
    Centr = cat(1, cells.Centroid);
    
    param.mem = 0;
    param.dim = 2;
    param.good = 0;
    param.quiet = 1;
    param.stepLength = maxDisplacement;
    
    PList = [];
    for tim = 1:max(PosList(:,3))
        idxT = find(PosList(:,3) == tim);
        if ~isempty(idxT)
            PList = [PList; PosList(idxT,:)];
        else
            PList = [PList; 0 0 tim 0];
        end
    end
    
    % Call tracking function, based on Crocker Grier
    res = trackCommentsshort(PList(:,1:3),param.stepLength, param);
    ind = find(res(:,1) ~= 0);
    res = res(ind,:);
    % res: x-Coord | y-Coord | time [frame] | path number
    
    Dind = 1;
    resalt = res;
    for iconv = unique(res(:,4))'
        clear  a b PathX PathY indices cellNB
        indices = find(res(:,4) == iconv);
        PathX = res(find(res(:,4) == iconv) ,1);
        PathY = res(find(res(:,4) == iconv) ,2);
        cellNB = PosList(find((PathX(1) == PosList(:,1)) & (PathY(1) == PosList(:,2))),4); 
        % find Cell number
        res(indices, 5) = cellNB(1);
        [a b] = convCoord(PathX, PathY, alpha(cellNB(1)), Centr(cellNB(1),:));
        % transformation of tracks wrt to the cells internal axis. Useful
        % only if there are single seperated cells. Otherwise can be
        % ignored
        res(indices,1) = a;
        res(indices,2) = b;
    end
    ce = cat(1, cells.Centroid);
    MjAx = cat(1, cells.MajorAxisLength);
    
    % Count number of tracks per cell
    zellen = unique(res(:,5))';
    zellen = zellen(zellen > 0) ;
    if ~isempty(zellen)
        for k = zellen
            TracksPerCell = [TracksPerCell; sum(res(:,5) == k)];
        end
    end
    
    paths = []; vels = []; angles = []; Dangles = []; steps = []; nbPath = 0; Dcents = []; lens = []; Int = [];
    for j = 1:max(res(:,4))
        clear path angle vel step Dangle Dcent len
        path_idx = find(res(:,4) == j);
        path = res(path_idx,:);
        pathalt = resalt(path_idx,:);
        leng = length(path(:,1));
        if leng >= 1
            IntJ = zeros(1, size(IntList, 2));
            NB = NB + 1;
            nbPath = nbPath + 1;
            if leng > 1
                for k = 1:length(path(:,1))-1
                    PosList(find((PathX(1) == PosList(:,1)) & (PathY(1) == PosList(:,2))),4);
                    IntJind = find((pathalt(k,1) == PosList(:,1)) & (pathalt(k,2) == PosList(:,2)));
                    IntJ(k, :) = IntList(IntJind(1), :);
                    step(k) = sqrt((path(k,1)-path(k+1,1))^2 + (path(k,2)-path(k+1,2))^2);
                    cellNB = res(k,5);
                    Dcent(k) = sqrt((path(k,1)-ce(cellNB,1))^2 + (path(k,2)-ce(cellNB,2))^2)/(MjAx(cellNB)/2);
                    vel(k) = step(k)/(path(k+1,3) - path(k,3));
                    angle(k) = acos((path(k,1)-path(k+1,1))/step(k))/pi*180;
                    len(k) = leng;
                    
                    if k > 1
                        Dangle(k-1) = angle(k) - angle(k-1);
                    else
                        Dangle = [];
                    end
                end
                IntJind = find((pathalt(k+1,1) == PosList(:,1)) & (pathalt(k+1,2) == PosList(:,2)));
                IntJ(k+1, :) = IntList(IntJind(1), :);
                Int = [Int; IntJ];
                angles = [angles angle];
                Dangles = [Dangles Dangle];
                Dcents = [Dcents Dcent];
                vels = [vels vel];
                steps = [steps step];
                lens = [lens len];
            else
                Int = [Int; 0 0 0 0 0 0];
            end
            
            paths = [paths; path];
            pathsNoTrafo = [pathsNoTrafo; pathalt];
            
            if leng >= 5
                clear Path PathNEW Steps MreBInt MreBIntS Pathneu PathneuNEW msd
                Path = resalt(path_idx,:);
                Pathneu = res(path_idx,1:4);
                AnzPfade = AnzPfade + 1;
                SD = [];
                for p = 1:size(Path,1)
                    PathNEW(p,:) = [Path(p,1) Path(p,2) 1] ;
                    PathneuNEW(p,:) = [Pathneu(p,1) Pathneu(p,2) 1] ;
                end
                
                msd = calcMSD(Path);
                limit = length(msd);
                x = (1:limit)*(TStep*0.001);
                fo = fitoptions('Method','NonlinearLeastSquares','Robust','Off', 'Algorithm',...
                    'Trust-Region', 'Lower', [0 0], 'Upper',[0.0014*3 4],'StartPoint',[0 0],...
                    'MaxFunEvals', 600, 'MaxIter', 400);
                ft = fittype('m*x + b','options',fo);
                [curve,gof] = fit(x',msd'*0.075^2,ft); % pixel size is 75 nm
                DiffAll = [DiffAll curve.m/4];
                
                Cx = mean(PathNEW(:,1));
                Cy = mean(PathNEW(:,2));
                for p = 1:size(Path,1)
                    distC(p) = (PathNEW(p,1)-Cx)^2 + (PathNEW(p,2)-Cy)^2;
                end
                AlldistC = [AlldistC distC];
                
                if DiffAll(end) > 0.025
                    fast = fast + 1;
                else
                    slow  = slow + 1;
                end
                StorePaths = [StorePaths; PathNEW(:, 1:2) ...
                    ones(size(PathNEW, 1), 1)*AnzPfade ones(size(PathNEW, 1), 1)*...
                    DiffAll(end)];
            end
        end
    end
    AllDcent  = [AllDcent Dcents];
    Allsteps  = [Allsteps steps];
    Alllens   = [Alllens lens];
    Allangles = [Allangles angles];
    paths = pathsNoTrafo; % comment out if transformed tracks are needed
    na = 'sampledata';
    na = [n, na, '-pathsC'];
    if(ToSave)
        save(na, 'paths','param', 'TStep', 'nbPath', 'cells', ...
            'Int', 'refimg', 'pathsNoTrafo')
    end
    disp([max(size(PList)) TStep param.stepLength])
catch
    disp('no peaks found on movie')
end
