function [paths] = sptFromPosList(fdir,folder,ImagingInterval,maxDisplacement,dir_for_mask)
n = ['.' filesep folder filesep];

load(dir_for_mask) % to load the mask

StorePaths = [];
fileList = dir([n,'*.mat']); 
name = {fileList.name};
a1 = ~contains(name,'paths');
name = name(a1);

AllDcent = [];
Allsteps = [];
AllSteps = [];
AllStepsMean = [];
AllStepsErr = [];
AllMreBInt = [];
AllMreBIntMean = [];
MreBIntSlow = [];
MreBIntFast = [];
AllMreBIntS = [];
Alllens = [];
AlldistC = [];
AllRg = [];
Allangles = [];
NB = 0;
RG = [];
KO = [];
fast = 0; slow = 0;
AnzPfade = 0; simSpotsCell = []; DiffAll = [];

for i = 1:length(name)
    name{i}
    TStep = ImagingInterval;
    clear paths angles vels steps res ce Dcent PosList
    [n, name{i}]
    load([n, name{i}])
    TStep = ImagingInterval;
    [n, name{i}]
    BW = BW(1:512, 1:512);

    PosList = unique(PosList, 'rows');
    PosList = PosList(mod(PosList(:,1), 1)~=0, :);

    dummyCell = [];
    for ceI = 1:length(cells)
        if not(isempty(cells(ceI).Area))
            dummyCell = [dummyCell; cells(ceI)];
        end
    end
    clear cells
    cells = dummyCell;

    refimgMreB = [fdir refimgMreB ];
    refimgMreB = strrep(refimgMreB,'\',filesep); refimgMreB = strrep(...
        refimgMreB,'/',filesep);
    IMG = zeros(512,512);
    IMG = IMG ./ max(max(IMG(BW > 0)));

    xbar = 30;
    ybar = 40;

    POSLIST = [];
    INTLIST = [];
    test = [];
    for j = 1:max(PosList(:,3))
        ind = find(PosList(:,3)==j);
        if isempty(ind)
            POSLIST = [POSLIST; 0 0 j 0];
            INTLIST = [INTLIST; 0 0 0 0 j 0];
        else
            for k = ind'
                cellNB = BW(round(PosList(k,2)), round(PosList(k,1)));
                if cellNB == 0
                    cellNB = BW(ceil(PosList(k,2)), ceil(PosList(k,1)));
                    if cellNB == 0
                        cellNB = BW(floor(PosList(k,2)), floor(PosList(k,1)));
                    end
                end
                if cellNB == 0
                    POSLIST = [POSLIST; 0 0 j 0];
                    INTLIST = [INTLIST; 0 0 0 0 j 0];
                else
                    POSLIST = [POSLIST; [PosList(k,1:3) cellNB]];
                    INTLIST = [INTLIST; [[0 0 0 0] PosList(k,3) cellNB]];
                end
            end
        end
    end
    PosList = POSLIST;
    IntList = INTLIST;
    
    PosListGem = [];
    for zeit = 1:max(POSLIST(:,3))
        subPosList = POSLIST(POSLIST(:,3)==zeit, :);
        zellen = unique(subPosList(:,4))';
        zellen = zellen(zellen > 0) ;
        if ~isempty(zellen)
            for k = zellen 
                if (sum(subPosList(:,4) == k) > 1)
                    PosListGem = [PosListGem; subPosList(subPosList(:,4) == k,:)];
                end
            end
        end
    end
    if ~isempty(PosListGem)
        simSpotsCell = [];
        for j = unique(PosListGem(:,3))'
            subPosListGem = PosListGem(PosListGem(:,3) == j, :);
            for k = unique(subPosListGem(:,4))'
                simSpotsCell = [simSpotsCell; sum(subPosListGem(:,4) == k)];
            end
        end
    end
    
    
    idx = find(PosList(:,4) ~= 0);
    PosList = PosList(idx,:);
    IntList = IntList(idx,:);
    for iT = 1:floor(max(PosList(:,3))/10)*10/10+1
        TimeGrob = floor(PosList(:,3)/10)*10/10+1;
        idxTime = find(TimeGrob == iT);
        hold on
    end
       
    param.mem = 0;
    disp(param.mem)
    param.dim = 2;
    param.good = 0;
    param.quiet = 1;
    param.stepLength = maxDisplacement;
    PList = []; 
    
    %korrigierte Version (Anfang):
    PosList(:,3) = PosList(:,3);
    for tim = 1:max(PosList(:,3))
        idxT = find(PosList(:,3) == tim);
        if ~isempty(idxT) 
            PList = [PList; PosList(idxT,:)];
        else
            PList = [PList; 0 0 tim 0];
        end
    end
    %korrigierte Version (Ende):

    res = trackCommentsshort(PList(:,1:3),param.stepLength, param);
    ind = find(res(:,1) ~= 0);
    res = res(ind,:);
    Dind = 1;
    resalt = res;
    resSAFE = res;

    for iconv = unique(res(:,4))'
        clear  a b PathX PathY indices cellNB
        indices = find(res(:,4) == iconv);
        PathX = res(find(res(:,4) == iconv) ,1);
        PathY = res(find(res(:,4) == iconv) ,2);
        cellNB = PosList(find((PathX(1) == PosList(:,1)) & (PathY(1) ==...
            PosList(:,2))),4); % find Cell number
        res(indices, 5) = cellNB(1);
    end

    ce = cat(1, cells.Centroid);
    MjAx = cat(1, cells.MajorAxisLength);
    paths = []; vels = []; angles = []; Dangles = []; steps = []; 
    nbPath = 0; Dcents = []; lens = []; Int = [];
    
    for j = 1:max(res(:,4))
        clear path angle vel step Dangle Dcent len 
        path_idx = find(res(:,4) == j);
        path = res(path_idx,:);
        pathalt = resalt(path_idx,:);
        leng = length(path(:,1));
        rg = []; 
        if leng > 1
            IntJ = zeros(1, size(IntList, 2));
            NB = NB + 1;
            nbPath = nbPath + 1;
            if leng > 1
                for k = 1:length(path(:,1))-1
                    PosList(find((PathX(1) == PosList(:,1)) &...
                        (PathY(1) == PosList(:,2))),4);
                    IntJind = find((pathalt(k,1) == PosList(:,1)) & ...
                        (pathalt(k,2) == PosList(:,2)));
                    IntJ(k, :) = IntList(IntJind(1), :);
                    step(k) = sqrt((path(k,1)-path(k+1,1))^2 + (path(k,2)-path(k+1,2))^2);
                    cellNB = res(k,5);
                    Dcent(k) = sqrt((path(k,1)-ce(cellNB,1))^2 + (path(k,2)-...
                        ce(cellNB,2))^2)/(MjAx(cellNB)/2);
                    vel(k) = step(k)/(path(k+1,3) - path(k,3));
                    angle(k) = acos((path(k,1)-path(k+1,1))/step(k))/pi*180;
                    len(k) = leng;

                    if k > 1
                        Dangle(k-1) = angle(k) - angle(k-1);
                    else
                        Dangle = [];
                    end
                    if length(path(:,1)) > 3
                        for h = 1:k-1
                            rg(length(rg) + 1) = sqrt((path(k+1,1)-path(k-h,1))^2 + ...
                                (path(k+1,2)-path(k-h,2))^2);
                        end
                    end
                end
                IntJind = find((pathalt(k+1,1) == PosList(:,1)) & (pathalt(k+1,2)...
                    == PosList(:,2)));
                IntJ(k+1, :) = IntList(IntJind(1), :);
                Int = [Int; IntJ];
                angles = [angles angle];
                Dangles = [Dangles Dangle];
                Dcents = [Dcents Dcent];
                vels = [vels vel];
                steps = [steps step];
                lens = [lens len];
                RG = [RG rg];
            else 
                Int = [Int; 0 0 0 0 0 0];
            end  
            paths = [paths; path];

            if (leng >= 4)
                clear Path PathNEW Steps MreBInt MreBIntS Pathneu PathneuNEW msd
                Path = resalt(path_idx,:);
                Pathneu = res(path_idx,1:4);
                AnzPfade = AnzPfade + 1;
                SD = [];
                for p = 1:size(Path,1)
                    PathNEW(p,:) = [Path(p,1) Path(p,2) 1];
                    PathneuNEW(p,:) = [Pathneu(p,1) Pathneu(p,2) 1];
                    MreBInt(p) = mean(reshape(IMG(round(PathNEW(p,2))-1:round(PathNEW(p,2))+1, ...
                        round(PathNEW(p,1))-1:round(PathNEW(p,1))+1),[],1));
                    if p > 1
                        Steps(p-1) = (PathNEW(p,1)-PathNEW(p-1,1))^2 + (PathNEW(p,2)-PathNEW(p-1,2))^2;
                        MreBIntS(p-1) = mean(reshape(IMG(round(PathNEW(p,2))-1:round(PathNEW(p,2))+1,...
                            round(PathNEW(p,1))-1:round(PathNEW(p,1))+1),[],1));
                    end
                    DX2 = [];
                    dt = p;
                    for dx = 1:length(PathNEW(:,1))-dt
                        DX2(dx, 1) = (PathNEW(dx,1)-PathNEW(dx+dt,1))^2 +...
                            (PathNEW(dx,2)-PathNEW(dx+dt,2))^2;
                        DX2(dx, 2) = dt;
                    end     
                    SD = [SD; DX2];
                end
                
                SD = [];
                for p = 1:length(path)
                    DX2 = [];
                    dt = p;
                    for dx = 1:length(path(:,1))-dt
                        DX2(dx, 1) = (path(dx,1)-path(dx+dt,1))^2 + (path(dx,2)-path(dx+dt,2))^2;
                        DX2(dx, 2) = dt;
                    end     
                    SD = [SD; DX2];
                end
                msd(1) = 0.0014/0.075^2; % pixel size is 75nm
                DX2 = SD;
                for t = 1:max(DX2(:,2))
                    msd(t+1) = mean(DX2(find(DX2(:,2) == t),1));       
                end
                limit = length(msd);
                x = (1:limit-1)*(TStep*0.001);
                fo = fitoptions('Method','NonlinearLeastSquares','Robust','Off', 'Algorithm',...
                    'Trust-Region', 'Lower', [0 0], 'Upper',[0.0014*3 4],'StartPoint',...
                    [0 0], 'MaxFunEvals', 600, 'MaxIter', 400);

                Cx = mean(PathNEW(:,1));
                Cy = mean(PathNEW(:,2));
                for p = 1:size(Path,1)
                    distC(p) = (PathNEW(p,1)-Cx)^2 + (PathNEW(p,2)-Cy)^2;
                end
                Rg = sqrt(mean(distC));
                AlldistC = [AlldistC distC];
                AllRg = [AllRg Rg];
                AllMreBInt = [AllMreBInt MreBInt];
                AllMreBIntS = [AllMreBIntS MreBIntS];
                AllMreBIntMean = [AllMreBIntMean mean(MreBInt)];
                AllSteps = [AllSteps Steps];
                AllStepsMean = [AllStepsMean mean(Steps)];
                AllStepsErr = [AllStepsErr std(Steps)];
                
            end
        end
    end
    AllDcent = [AllDcent Dcents];
    Allsteps = [Allsteps steps];
    Alllens = [Alllens lens];
    Allangles = [Allangles angles];

    na = strrep(name{i},'.mat','');
    na = [n, na, '-paths.mat'];
    save(na, 'paths','param', 'TStep', 'nbPath', 'cells', 'Int', 'refimg')
    Datei = name{i};
end

%%