function [msd] = calcMSD(path)
SD = [];
for k = 1:size(path(:,1), 1)-1
    DX2 = [];
    dt = k;
    for dx = 1:length(path(:,1))-dt
        DX2(dx, 1) = (path(dx,1)-path(dx+dt,1))^2 + (path(dx,2)-path(dx+dt,2))^2;
        DX2(dx, 2) = dt;
    end     
    SD = [SD; DX2];
end

dt = size(path(:,1), 1);
for dx = 1:length(path(:,1))-dt
    DX2(dx, 1) = (path(dx,1)-path(dx+dt,1))^2 + (path(dx,2)-path(dx+dt,2))^2;
    DX2(dx, 2) = dt;
end     
SD = [SD; DX2];

% msd(1) = (0.023)^2;
DX2 = SD;
for t = 1:max(DX2(:,2))
    msd(t) = mean(DX2(find(DX2(:,2) == t),1));       
end

% msd;
