path4Data = '.\';

%%%%%%% Figure 2D %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data = load([path4Data, 'Figure2-source data 1.mat']);

x = (0:100:5000)+100/2;

h_singlefigure = figure;
hold on;
y10 = hist(data.RT_FirstDay, x);
y_sum = sum(y10);
y10 = y10/y_sum;
h_bar = bar(x,y10', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 2: First Day');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.14], 'YTick', [0 0.1], 'YTickLabel', [0 0.1]*100);
line([1000 1000], [0 0.14], 'Color', [0 0 1]);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');


h_singlefigure = figure;
hold on;
y20 = hist(data.RT_LastDay, x);
y_sum = sum(y20);
y20 = y20/y_sum;
h_bar = bar(x,y20', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 2: After several days');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.12], 'YTick', [0 0.1], 'YTickLabel', [0 0.1]*100);
line([1000 1000], [0 0.12], 'Color', [0 0 1]);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');
