path4Data = '.\';
data = load(fullfile(path4Data, 'Figure3-source data 1.mat'));

%%%%%%% Figure 3F 2D plot %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
NoSelectiveList = (data.ResponsiveCells(:,3) == 0 & data.ResponsiveCells(:,4)==0);
SelectiveAllList = (data.ResponsiveCells(:,3) > 0 | data.ResponsiveCells(:,4) > 0);
figure; plot(data.ResponsiveCells(NoSelectiveList,1), data.ResponsiveCells(NoSelectiveList,2), 'o', 'MarkerSize', 4, 'MarkerEdgeColor', [0 0 0]);
hold on; plot(data.ResponsiveCells(SelectiveAllList,1), data.ResponsiveCells(SelectiveAllList,2), 'o', 'MarkerSize', 4, 'MarkerEdgeColor', [0 0 0], 'MarkerFaceColor', [0 0 0]);
axis([-3 3 -3 3]);axis square; plot([0 0], [-3 3], 'Color', [0 0 0]); plot([-3 3], [0 0], 'Color', [0 0 0]); plot([-3 3], [-3 3], 'Color', [0 0 0]);
axis off;
text(-3,-0.1, '-3');
text(3,-0.1, '3');
text(-0.2, 3, '3');
text(-0.2, -3, '-3');
title('Figure 3: 2D plot');

%%%%%%% Figure 3F 'Before' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure('Position', [100 100 400 200]);
x = [-3:0.1:3];gw = 1.0;
hold on;
ContraSigList = (data.ResponsiveCells(:,3) == 1);
IpsiSigList   = (data.ResponsiveCells(:,3) == 2);
SignificantInOtherConditionList       = (data.ResponsiveCells(:,3)==0 & data.ResponsiveCells(:,4)>0);

NoSelectiveData = data.ResponsiveCells(NoSelectiveList,1);
ContraSigData = data.ResponsiveCells(ContraSigList,1);
IpsiSigData = data.ResponsiveCells(IpsiSigList,1);
SignificantInOtherConditionData   = data.ResponsiveCells(SignificantInOtherConditionList,1);
yb0 = hist(NoSelectiveData, x); yb1 = hist(SignificantInOtherConditionData, x);
yb2 = hist(ContraSigData, x); yb3 = hist(IpsiSigData, x);
Sum_y = sum([yb0, yb1, yb2, yb3]);
yb0 = yb0/Sum_y;yb1 = yb1/Sum_y;yb2 = yb2/Sum_y; yb3 = yb3/Sum_y;
h_bar = bar(x, [yb2; yb3; yb1; yb0; ]', gw, 'stacked') ;
set(h_bar(1), 'FaceColor', [1 0 1], 'EdgeColor', [0 0 0]);  
set(h_bar(2), 'FaceColor', [0 1 1], 'EdgeColor', [0 0 0]);
set(h_bar(3), 'FaceColor', [0 0 0], 'EdgeColor', [0 0 0]);
set(h_bar(4), 'FaceColor', [1 1 1], 'EdgeColor', [0 0 0]);
plot([0 0], [0 0.12], 'k');
title('Figure 3: Selective index (Before)');
set(gca, 'TickDir', 'out', 'XLim', [-3-0.02 3+0.02], 'YLim', [0 0.12], 'XTick', [-3:1:3], ...
    'Ytick', [0 0.1], 'YTickLabel', [0 0.1]*100);
xlabel('SelectiveIndex (Before)');
ylabel('Proportion of cells (%)');

%%%%%%% Figure 3F 'After' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure('Position', [100 100 400 200]);
hold on;
ContraSigList = (data.ResponsiveCells(:,4) == 1);
IpsiSigList   = (data.ResponsiveCells(:,4) == 2);
SignificantInOtherConditionList       = (data.ResponsiveCells(:,3)>0 & data.ResponsiveCells(:,4)==0);
NoSelectiveData = data.ResponsiveCells(NoSelectiveList,2);
ContraSigData = data.ResponsiveCells(ContraSigList,2);
IpsiSigData = data.ResponsiveCells(IpsiSigList,2);
SignificantInOtherConditionData   = data.ResponsiveCells(SignificantInOtherConditionList,2);

yb0 = hist(NoSelectiveData, x); yb1 = hist(SignificantInOtherConditionData, x);
yb2 = hist(ContraSigData, x); yb3 = hist(IpsiSigData, x);
Sum_y = sum([yb0, yb1, yb2, yb3]);
yb0 = yb0/Sum_y; yb1 = yb1/Sum_y; yb2 = yb2/Sum_y; yb3 = yb3/Sum_y;
h_bar = bar(x, [yb2; yb3; yb1; yb0; ]', gw, 'stacked') ;
set(h_bar(1), 'FaceColor', [1 0 1], 'EdgeColor', [0 0 0]);
set(h_bar(2), 'FaceColor', [0 1 1], 'EdgeColor', [0 0 0]);
set(h_bar(3), 'FaceColor', [0 0 0], 'EdgeColor', [0 0 0]);
set(h_bar(4), 'FaceColor', [1 1 1], 'EdgeColor', [0 0 0]);
plot([0 0], [0 0.13], 'k');
title('Figure 3: Selective index (After)');
set(gca, 'TickDir', 'out', 'XLim', [-3-0.02 3+0.02], 'YLim', [0 0.13], 'XTick', [-3:1:3], ...
    'Ytick', [0 0.1], 'YTickLabel', [0 0.1]*100);
xlabel('SelectiveIndex (After)');
ylabel('Proportion of cells (%)');

%%%%%%% Figure 3F 'Difference' %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
x_dia = [(-3*1.6):0.15:(3*1.6)];
plasticityEffect = data.ResponsiveCells(:,1) - data.ResponsiveCells(:,2);
figure('Position', [100 100 400 200]);
hold on;
NoSelectiveData = plasticityEffect(NoSelectiveList,1);
SelectiveAllData = plasticityEffect(SelectiveAllList,1);

yb0 = hist(NoSelectiveData, x_dia); yb1 = hist( SelectiveAllData, x_dia);
Sum_y = sum([yb0, yb1]);
yb0 = yb0/Sum_y; yb1 = yb1/Sum_y;
h_bar = bar(x_dia, [yb1; yb0]', gw, 'stacked') ;
set(h_bar(1), 'FaceColor', [0 0 0], 'EdgeColor', [0 0 0]);
set(h_bar(2), 'FaceColor', [1 1 1], 'EdgeColor', [0 0 0]);
plot([0 0], [0 0.15], 'k');
set(gca, 'TickDir', 'out', 'XTick', [-4:1:4], 'XTickLabel', {'', '-3', '', '', 0, '', '', '3', ''});

title('Figure 3: D(Selective index)');
set(gca, 'TickDir', 'out', 'XLim', [-3*1.6-0.02 3*1.6+0.02], 'YLim', [0 0.15], 'XTick', [-3:1:3], ...
    'Ytick', [0 0.1], 'YTickLabel', [0 0.1]*100);
xlabel('D(SelectiveIndex)');
ylabel('Proportion of cells (%)');
