path4Data = '.\';

%%%%%%% Figure 4D %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data = load([path4Data, 'Figure4-source data 1.mat']);

x = (0:100:5000)+100/2;

h_singlefigure = figure;
hold on;
y10 = hist(data.RT_UniFirst_Con, x);
y_sum = sum(y10);
y10 = y10/y_sum;
h_bar = bar(x,y10', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4D Unilateral First Day Control');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.11], 'YTick', [0 0.1], 'YTickLabel', [0 0.1]*100);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');


h_singlefigure = figure;
hold on;
y20 = hist(data.RT_UniFirst_Exp, x);
y_sum = sum(y20);
y20 = y20/y_sum;
h_bar = bar(x,y20', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4D Unilateral First Day Experimental');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.25], 'YTick', [0 0.1 0.22], 'YTickLabel', [0 0.1 0.22]*100);
line([1000 1000], [0 0.25], 'Color', [0 0 1]);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');


%%%%%%% Figure 4B %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data = load([path4Data, 'Figure4-source data 2.mat']);

x = (0:100:5000)+100/2;

h_singlefigure = figure;
hold on;
y10 = hist(data.RT_UniAfter_Con, x);
y_sum = sum(y10);
y10 = y10/y_sum;
h_bar = bar(x,y10', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4E Uni After Training Control');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.25], 'YTick', [0 0.1 0.2], 'YTickLabel', [0 0.1 0.2]*100);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');

h_singlefigure = figure;
hold on;
y20 = hist(data.RT_UniAfter_Exp, x);
y_sum = sum(y20);
y20 = y20/y_sum;
h_bar = bar(x,y20', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4E Uni After Training Experimental');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.15], 'YTick', [0 0.1], 'YTickLabel', [0 0.1]*100);
line([1000 1000], [0 0.15], 'Color', [0 0 1]);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');

%%%%%%% Figure 4C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data = load([path4Data, 'Figure4-source data 3.mat']);

x = (0:100:5000)+100/2;

h_singlefigure = figure;
hold on;
y10 = hist(data.RT_Bilateral_Con, x);
y_sum = sum(y10);
y10 = y10/y_sum;
h_bar = bar(x,y10', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4F Bilateral Control');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.25], 'YTick', [0 0.1 0.2], 'YTickLabel', [0 0.1 0.2]*100);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');


h_singlefigure = figure;
hold on;
y20 = hist(data.RT_Bilateral_Exp, x);
y_sum = sum(y20);
y20 = y20/y_sum;
h_bar = bar(x,y20', 1, 'stack');
set(h_bar,{'FaceColor'},{[0 0 0]}); title('Figure 4F Bilateral Experimental');
set(gca, 'TickDir', 'out', 'XLim', [0 5200], 'XTick', [0:1000:5000], 'XTickLabel', [0:1000:5000]/1000, ...
    'YLim', [0 0.18], 'YTick', [0 0.1], 'YTickLabel', [0 0.1]*100);
line([1000 1000], [0 0.18], 'Color', [0 0 1]);
xlabel('Reaction Time (s)');
ylabel('Trials Proportion (%)');

