path4Data = '.\';

%%%%%%% Figure 1F %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
data = load([path4Data, 'Figure1-source data 1']);

h_CminusI_figure = figure;

x = [-0.15:0.005:0.15];

y00 = hist(data.NoSig, x);
y10 = hist(data.ContraSig, x);
y20 = hist(data.IpsiSig, x);
Sum_y = sum([y00, y10, y20]);
y00 = y00/Sum_y;
y10 = y10/Sum_y;
y20 = y20/Sum_y;

hold on;
h_bar = bar(x, [y10; y20; y00;]', 1.0, 'stacked') ;
set(h_bar(3), 'FaceColor', [1 1 1], 'EdgeColor', [0 0 0]);
set(h_bar(1), 'FaceColor', [1 0 1], 'EdgeColor', [0 0 0]);
set(h_bar(2), 'FaceColor', [0 1 1], 'EdgeColor', [0 0 0]);
plot([0 0], [0 0.1], 'k');
axis([-0.15 0.15 0 0.07]);

set(gca, 'TickDir', 'out', 'XLim', [-0.15 0.15], 'YLim', [0 0.07], 'XTick', [-0.1:0.1:0.1], 'XTickLabel', [-0.1:0.1:0.1]*100, ...
    'Ytick', [0 0.05], 'YTickLabel', [0 0.05]*100);
xlabel('Difference in DF/F increase');
ylabel('Proportion of cells (%)');
title('Figure 1');
