function [pVr_bins_cell, time_vector, EPSCs, peak1s, peak2s_extr, pprs_extr, states_all_cell, pVr1s, ttps, act_1s, act_2s] = testing_the_system(stoch_on_off, rand_ves_on_off, CalC_on_off, par_init, CaExtracellular, save_data, savefilename, save_calc_loc, pVr2_hack, stim_freq, num_stim)

%Description:
% Calls a single run of calcium and/or det./stoch. exocytosis simulation (depending on input choice).
% Output: Results from simulation e.g. amplitudes, PPRs, pVrs, states from simulation, traces, etc.

%%Variables:
% stoch_on_off: Exocytosis simulation choice. Deterministic (==0), stochastic (==1), or both (==2).
% rand_ves_on_off: Vesicle placement. See determ_vesicle_distances.m.
% CalC_on_off: 0: No calcium simulation (if calcium files are already generated). 1: Delete old files and simulate new. >1: Simulate calcium without deleting old files.
% par_init: Parameter vector from parameter_choice.m
% CaExtracellular: Extracel. calcium in simulation.
% save_data: Defines how many results are saved. See bottom of simulation_call_stoch.m and simulation_call_det.m. If ==3 only 20 stochastic simulations. If ==66 100 simulations (used when running many reps in sets of 100).
% savefilename: Part of result file name generated by parameter_choices.m.
% save_calc_loc: 1 or 2. Two choices of folders to save calcium files. If ==2, simulation time is 163.5 ms. 

long_sim_on_off = 0;
par = model_parameters_det(par_init);

num_ves = par(22);

num_calc = length(CaExtracellular);

if num_calc ==1
    savefilename = [savefilename '_Ca' num2str(CaExtracellular)];
end

if (sum(rand_ves_on_off == [0 1]) && stoch_on_off == 0) %Use 180 bins in deterministic simulations
    num_bins = 180;
elseif (sum(rand_ves_on_off == [9 10])) %Perimeter models
    num_bins = 1;
elseif rand_ves_on_off == 1000 %Used for pVr2 estimation.
    num_bins = 1000;
else %Not used in stochastic simulations. Arbitrary.
    num_bins = num_ves;
end



% %%%%%Calculate residual calcium
CaMax_rest = par(23); 
k_M_rest = par(24);
CaRest = calculate_CaRest(k_M_rest, CaMax_rest, CaExtracellular);

%Define location of calcium files. If ==2: Simulate 163.5 ms instead of
%20.5.
if save_calc_loc == 1
    folder_name = './Sim_data/CalC_files/';
elseif save_calc_loc == 2
    folder_name = './Sim_data/new_calcium/';
end


%Run calcium simulations in parallel. If CalC_on_off == 1: Delete old
%files.
if CalC_on_off > 0
    
    if CalC_on_off == 1 || CalC_on_off == 100
        if ~(strcmp(computer, 'MACI64'))
        system(['rm ' folder_name 'newpar*']);
        system(['rm ' folder_name 'Calcium_*']);
        end
    else
    disp('WARNING: Not deleting calcium files')
    end
    
if CalC_on_off == 100
    num_stim = 10;
    stim_freq = 50;
    train_on_off = 1;
% else
%     num_stim = 2;
%     stim_freq = 100;
%     train_on_off = 0;
end
    
    parfor l = 1:num_calc
        if save_calc_loc == 1
%             RunCalC_det(CaExtracellular(l), par, CaRest(l), num_stim, stim_freq);
            RunCalC_det(CaExtracellular(l), par, CaRest(l), num_stim, stim_freq, save_calc_loc, long_sim_on_off);

        elseif save_calc_loc == 2
            RunCalC_det_altsaving(CaExtracellular(l), par, CaRest(l), 1, num_stim, stim_freq, save_calc_loc, long_sim_on_off); 
        end
    end
end

if sum(stoch_on_off == [0 1 2])

    if ((stoch_on_off == 0) || (stoch_on_off == 2))
        [pVr_bins_cell, time_vector, EPSCs, peak1s, peak2s_extr, pprs_extr, states_all_cell, pVr1s, ttps, act_1s, act_2s, ~] = simulation_call_det(par, CaExtracellular, num_bins, rand_ves_on_off, save_data, savefilename, save_calc_loc, pVr2_hack, num_stim, stim_freq);

    end

    if ((stoch_on_off == 1) || (stoch_on_off == 2))
        [peak1_means, peak2_extr_means, ~, ~, ppr_extr_means, ttp_means, pVr1_means, ~, stoch_EPSC_means, ~, ~, time_vector] =  simulation_call_stoch(par, CaExtracellular, rand_ves_on_off, save_data, savefilename, save_calc_loc, num_stim, stim_freq);
    
    pVr_bins_cell = pVr1_means;
    EPSCs = stoch_EPSC_means;
    peak1s = peak1_means;
    peak2s_extr = peak2_extr_means; 
    pprs_extr = ppr_extr_means;
    states_all_cell = NaN;
    pVr1s = pVr1_means;
    ttps = ttp_means;
    act_1s = NaN;
    act_2s = NaN;
    end
    
    
else %If only doing calcium simulation
    disp('stoch_on_off is neither 0, 1, 2.')
    disp('Only CalC simulation has been run.')
    return;
end
