function [dists_for_hist] = read_image_fluor_average(plot_on_off, new_name, multiple_name)


load('distance_data.mat')

int_Rayl_orig = @(x)sqrt(2)/(sqrt(pi)*sigma_rayl^3).*x.^2.*exp(-(x.^2)/(2*sigma_rayl^2))
int_Rayl_WT = @(x)sqrt(2)/(sqrt(pi)*sigma_WT^3).*x.^2.*exp(-(x.^2)/(2*sigma_WT^2))


if ~new_name && ~multiple_name
    filename = 'Unc13A_centered_avg.tif';
    pic_count = 1;
elseif new_name && ~multiple_name
    filename = 'Unc13_centered_WT_new.tif';
    pic_count = 1;
elseif ~new_name && multiple_name
    filename_cell = {'01_w1118_DMSO_Unc13A_avg.tif'; '02_w1118_Unc13A_avg.tif'; '03_w1118_Unc13A_endogenous_avg.tif'; '04_w1118_DMSO_Unc13A_avg.tif'; '05_w1118_DMSO_Unc13A_avg.tif'}
    filename = filename_cell{multiple_name};
end

imreading = imread(filename);

pixel_size = 10;

intens_doubl = double(imreading);
intens_doubl_norm = intens_doubl/sum(intens_doubl(:));

num_pix = length(intens_doubl(:));

[pix_y, pix_x] = ind2sub(size(intens_doubl), 1:num_pix);

intens_norm_vector = intens_doubl_norm(:);

half_length = ceil((size(imreading))/2);

x_dist = abs(pix_x - half_length(1))*pixel_size;
y_dist = abs(pix_y - half_length(2))*pixel_size;

fluor_dists = sqrt(x_dist.^2 + y_dist.^2);

[fluor_dists_sorted, fluor_permutation] = sort(fluor_dists);
intens_norm_sorted = intens_norm_vector(fluor_permutation);

[uniq_dists_fluor, uniq_inds] = unique(fluor_dists_sorted);

uniq_intens_norm = zeros(1,length(uniq_inds));

for k = 1:(length(uniq_inds)-1)
    uniq_intens_norm(k) = sum(intens_norm_sorted(uniq_inds(k):(uniq_inds(k+1)-1)));
end
uniq_intens_norm(end) = sum(intens_norm_sorted(uniq_inds(end):end));
    
distance_counts = [diff(uniq_inds); (length(intens_norm_sorted) - uniq_inds(end))];

inds_180_3 = find(fluor_dists == uniq_dists_fluor(122))
inds_180 = find(fluor_dists == uniq_dists_fluor(121)) 

[y_ind180_3, x_ind180_3] = ind2sub([51 51], inds_180_3)
[y_ind180, x_ind180] = ind2sub([51 51], inds_180)


dists_for_hist = zeros(1e7,1);
count = 0;
for k = 1:num_pix
    weight_pix = intens_doubl(k)
    dists_for_hist((count+1):(count+weight_pix)) = repmat(fluor_dists(k), weight_pix, 1);
    count = count + weight_pix;
end

zero_ind = find(dists_for_hist > 0, 1, 'last');
dists_for_hist((zero_ind+1):end) = [];



if plot_on_off
%     figure
%     hold on
%     yyaxis left
%     plot(uniq_dists_fluor, (uniq_intens_norm./distance_counts'), 'b-o', 'MarkerFacecolor', 'b')
%     xlabel('Distance [nm]')
%     ylabel('Normalised intensity divided by number of pixels')
%     yyaxis right
%     fplot(int_rayl_orig, [0 350], 'LineStyle', '-', 'Color', 'k', 'LineWidth', 2)
%     fplot(int_rayl_WT, [0 350], 'LineStyle', '-', 'Color', 'k', 'LineWidth', 2)
%     ylabel('Probability density')
%     set(gca, 'TickDir', 'out', 'FontSize', 25)

    % figure
    % plot(uniq_dists_fluor(1:end-1),diff(uniq_dists_fluor), 'o')
    % xlabel('Distance [nm]')
    % ylabel('Bin size [nm]')






    for l = 37; %1:56
    figure;%('visible', 'off')
    
    hold on
    histogram(dists_for_hist_orig, 'BinEdges', (0:100)*(6+l*0.25), 'Normalization', 'probability')
    histogram(dists_for_hist, 'BinEdges', (0:100)*(6+l*0.25), 'Normalization', 'probability')

    % histogram(dist*1e3,35)
    xlim([0 400])
    ylim([0 0.12])
    hold on
    yyaxis right
    fplot(int_Rayl_orig, [0 400], 'LineStyle', '-', 'Color', 'k')
    fplot(int_Rayl_WT, [0 400], 'LineStyle', '-', 'Color', 'b')
    ylim([0 inf])
    set(gca, 'TickDir', 'out', 'FontSize', 25)
    % sigma_rayl = 72;
    % int_rayl_pdf_alt = @(x)sqrt(2)/(sqrt(pi)*sigma_rayl^3).*x.^2.*exp(-(x.^2)/(2*sigma_rayl^2))
    % fplot(int_rayl_pdf_alt, [0 300], 'LineStyle', '-', 'Color', 'r')
    % ylim([0 8e-3])
    saveas(gcf, ['./Flour_hist.eps'], 'epsc')
    end
    % 
    % load('distance_data.mat')
    % for l = 56:100
    % figure%('visible', 'off')
    % histogram(EM_dists, 'BinEdges', (0:100)*(6+l*0.25), 'Normalization', 'probability')
    % % histogram(dist*1e3,35)
    % 
    % xlim([0 350])
    % ylim([0 inf])
    % hold on
    % yyaxis right
    % fplot(rayl_pdf, [0 400], 'LineStyle', '-', 'Color', 'k')
    % ylim([0 inf])
    % % sigma_rayl = 72;
    % % int_rayl_pdf_alt = @(x)sqrt(2)/(sqrt(pi)*sigma_rayl^3).*x.^2.*exp(-(x.^2)/(2*sigma_rayl^2))
    % % fplot(int_rayl_pdf_alt, [0 300], 'LineStyle', '-', 'Color', 'r')
    % % ylim([0 8e-3])
    % % saveas(gcf, ['./Ad_hoc_figures/EM_histograms/EM_hist' num2str(l) '.png'], 'png')
    % end
end

